/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/editUserIdView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'io.ox/core/settings/util',
    'io.ox/core/yell',
    'oxguard/core/og_http',
    'oxguard/oxguard_core',
    'oxguard/core/passwordView',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, util, yell, http, core, PasswordView, gt) {

    'use strict';

    var POINT = 'oxguard/settings/editUserIdView',
        INDEX = 0;

    var dialog;

    function open(id) {
        dialog = openModalDialog(id);
        return dialog;
    }

    function openModalDialog(id) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Adding UserID'),
            width: 450
        })
        .inject({
        })
        .build(function () {
        })
        .addCancelButton()
        .addButton({ label: gt('Add'), action: 'add' })
        .on('add', function () {
            var dialog = this;
            editUserId(id)
            .done(function () {
                yell('success', gt('User ID added'));
                dialog.close();
                $('#refreshuserkeys').click();
            })
            .fail(function (e) {
                if (e && e.length > 1) yell('error', e);
                dialog.idle();
            });
        })
        .open();
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'header',
            render: function () {
                this.$body.addClass('addUserId');
                var label = $('<label>').append(gt('Add a name and email address to this public key.'))
                    .append('<br>');
                this.$body.append(
                    $('<div>').append(label)
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'name',
            render: function () {
                var input = util.input('nameInput', gt('Name'), new Backbone.Model());
                this.$body.append(
                    input
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'email',
            render: function () {
                var input = util.input('emailInput', gt('Email'), new Backbone.Model());
                this.$body.append(
                    input
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'password',
            render: function () {
                var label = $('<label for="passwordInput" id="passwordLabel">').append(gt('Please enter your key password'))
                    .append('<br>');
                var input = new PasswordView.view({ 'id': 'passwordInput' }).getProtected();
                this.$body.append(label).append(input);
            }
        }
    );

    function editUserId(id) {
        var def = $.Deferred();
        var email = $('[name="emailInput"]').val();
        var name = $('[name="nameInput"]').val();
        var password = $('#passwordInput').val();
        if (!core.validateEmail(email)) {
            def.reject(gt('Invalid Email Address'));
            return def;
        }
        if (name.length < 2) {
            def.reject(gt('Invalid Name'));
            return def;
        }
        if (password.length < 2) {
            def.reject(gt('Enter password'));
            return def;
        }
        var data = {
            password: password,
            email: email,
            name: name,
            keyid: id
        };
        core.metrics('settings', 'edit-pgp-uid');
        http.simplePost(ox.apiRoot + '/oxguard/keys?action=addUserId', '', data)
        .done(function (data) {
            if (core.checkJsonOK(data)) {
                def.resolve(gt('User ID added'));
            } else {
                def.reject();
            }
            return;
        })
        .fail(function (e) {
            def.reject(gt('Failed to add UserID') + e.responseText);
        });
        return def;
    }

    return {
        open: open
    };

});
