/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/downloadPrivateView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'oxguard/api/keys',
    'io.ox/core/yell',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalDialog, core, keysAPI, yell, gt) {

    'use strict';

    var POINT = 'oxguard/settings/downloadPrivate',
        INDEX = 0;

    function openModalDialog(keyid) {

        return new ModalDialog({
            async: true,
            point: POINT,
            title: gt('Download Key'),
            width: 450,
            model: keysAPI.pool.get('key').get(keyid) || new Backbone.Model({ 'id': keyid })
        })
        .inject({
            onClick: function (e) {
                this.download({
                    keyType: $(e.target).attr('data-keytype')
                });
            },
            download: function (params) {
                params = _.extend({
                    keyid: this.model.get('id'),
                    keyType: 'public'
                }, params);

                // metrics
                params.keyType.split('_').forEach(function (type) {
                    core.metrics('settings', 'download-' + type);
                });

                // public
                if (params.keyType === 'public') return keysAPI.downloadAsFile(params);

                // private, public_private
                var dialog = this;
                return core.getPassword(undefined, false).then(function (data) {
                    core.verifyPassword(data.password, params.keyid).then(function () {
                        keysAPI.downloadAsFile(params, { password: data.password })
                       .done(function () {
                           if (!dialog.disposed) dialog.close();
                       });
                    });
                });

            }
        })
        .addCloseButton()
        .open();
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'click-listener',
            render: function () {
                this.$body.on('click', 'button[data-keytype]', this.onClick.bind(this));
            }
        },
        {
            index: INDEX += 100,
            id: 'title',
            render: function () {
                var short = this.model.get('_short');
                if (!short) return;
                this.$('.modal-title').append(
                    $('<span>').text(': ' + short)
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'description',
            render: function () {
                this.$body.append(
                    $('<p>').append(
                        gt('Download your private key for use with other email programs. Do not distribute this key. It is for your use only.')
                    )
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'private',
            render: function () {
                this.$body.append(
                    $('<button type="button" class="upload-view btn btn-primary" id="downloadPrivate" data-keytype="private">')
                    .text(gt('Download PGP Private Key'))
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'public-private',
            render: function () {
                this.$body.append(
                    $('<button type="button" class="upload-view btn btn-primary" id="downloadPrivate" data-keytype="public_private">')
                    .text(gt('Download Public and Private Key'))
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'public',
            render: function () {
                this.$body.append(
                    $('<button type="button" class="upload-view btn btn-primary" id="downloadPrivate" data-keytype="public">')
                    .text(gt('Download PGP Public Key'))
                );
            }
        }

    );

    return {
        open: openModalDialog
    };
});
