/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2022 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/smime/smimeUpload', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'io.ox/core/yell',
    'oxguard/pgp/uploadkeys',
    'oxguard/smime/uploader',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, yell, uploadkeys, smimeUploader, gt) {

    function open() {
        var def = $.Deferred();
        createPasswordPrompt(def);
        return def;
    }

    function createPasswordPrompt(def) {
        return new ModalView({
            async: true,
            point: 'oxguard/smime/uploadKeys',
            title: gt('Upload S/MIME Keys'),
            width: 640,
            enter: 'ok',
            focus: '#pgppassword'
        })
        .build(function () {
        })
        .addButton({ label: gt('OK'), action: 'ok' })
        .addCancelButton()
        .on('cancel', function () {
            def.resolve();
        })
        .on('ok', function () {
            var dialog = this;
            var input = $('#smimeKeyFileInput');
            input.on('change', function () {
                var files = this.files;
                if (files.length > 0) {
                    smimeUploader.upload(files, $('#pgppassword').val(), $('#guardpassword').val()).done(function (data) {
                        if (data && data.id) {
                            yell('success', gt('Imported key for ID %s, Serial Number %s, with expiration date of %s', data.id, data.serial, new Date(data.validUntil).toDateString()));
                        }
                        def.resolve();
                        dialog.close();
                    })
                    .fail(function (e) {
                        yell(e);
                        $('#uploaderror').text(e);
                        input.unbind('change');
                        input.val(undefined);
                        dialog.idle();
                    });
                }
            });
            dialog.idle(); // unhide the input
            input.click();
            dialog.busy();
        })
        .open();
    }

    ext.point('oxguard/smime/uploadKeys').extend(
        {
            index: 100,
            id: 'passwordPrompts',
            render: function () {

                this.$body.append(
                    uploadkeys.createPrompts()
                );
            }
        },
        {
            index: 200,
            id: 'fileInput',
            render: function () {
                var input = $('<input type="file" id="smimeKeyFileInput" accept=".p12, .pfx" style="display:none;">');
                input.unbind('change');
                this.$body.append(input);
            }
        });

    return {
        open: open
    };

});
