/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/pgp/autocrypt/autocryptTransferView', [
    'io.ox/backbone/views',
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/core/og_http',
    'io.ox/core/yell',
    'oxguard/core/passwordView',
    'gettext!oxguard',
    'less!oxguard/pgp/autocrypt/style'
], function (views, ext, ModalView, http, yell, PasswordView, gt) {

    'use strict';

    var POINT = 'oxguard/autoCrypt/transfer',
        INDEX = 0;

    function open() {
        openModalDialog();
    }

    function openModalDialog() {
        var dialog = new ModalView({
            async: true,
            point: POINT,
            title: gt('Autocrypt Transfer Keys'),
            id: 'autoCryptStartTransfer',
            width: 640,
            model: new Backbone.Model(),
            enter: 'transfer'
        })
        .addButton({ label: gt('Transfer'), action: 'transfer' })
        .addCancelButton()
        .on('transfer', function () {
            require(['oxguard/pgp/autocrypt/autoCrypt'], function (autocrypt) {
                autocrypt.transferKeys($('#guardpassword').val())
                .then(function (resp) {
                    if (resp.data && resp.data.passcode) {
                        ox.load(['oxguard/pgp/autocrypt/autocryptTransferComplete']).done(function (view) {
                            view.open(resp.data.passcode);
                        });
                    }
                    if (resp.error) {
                        yell('error', resp.error);
                        dialog.idle();
                        return;
                    }

                    dialog.close();
                });
            });
        })
        .on('cancel', function () {
        });
        dialog.open();
        return dialog;
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'detail',
            render: function () {
                var div = $('<div class="autocryptTransfer">')
                .append(gt('This will send an email to you with your current private keys.  The keys will be securely encrypted.  You can then open this email in another AutoCrypt supported email client and import the keys to be used there.'));
                this.$body.append(
                    div
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'passwords',
            render: function () {
                var passdiv = $('<div>').addClass('autocryptTransfer');
                var newogpassword = new PasswordView.view({ 'id': 'guardpassword', 'class': 'password_prompt form-control', 'validate': false });
                var label = $('<label for="guardpassword">').append(gt('Please enter your %s password to authorize the transfer.', ox.guard.getName()));
                this.$body.append(passdiv.append(label).append(newogpassword.getProtected()));

            }
        });

    return {
        open: open
    };

});
