/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/core/passwords', [
    'gettext!oxguard',
    'less!oxguard/core/style'
], function (gt) {

    'use strict';

    // Compare two el1 to el2 values whenever el1 changes.  If hint
    // has value, then color and text if different
    function passwordCompare(el1, el2, hint) {
        var el1ToCompare = el1.getForCompare ? el1.getForCompare() : el1;  // Check if password View
        var el2ToCompare = el2.getForCompare ? el2.getForCompare() : el2;
        $(el1ToCompare).on('input', function () {
            $(el1ToCompare).removeClass('oxguard_badpass');
            if ($(el1ToCompare).length >= 1) {
                el2ToCompare.removeClass('oxguard_warnpass').removeClass('oxguard_badpass').removeClass('oxguard_goodpass');  // remove color markup of the first password box
                if ($(el1ToCompare).val() !== $(el2ToCompare).val()) {
                    $(el1ToCompare).addClass('oxguard_badpass');
                    if (hint !== undefined) {
                        hint.removeClass('oxguard_hint_bad').removeClass('oxguard_hint_good').removeClass('oxguard_hint_warn');
                        hint.addClass('oxguard_hint_bad').text(gt('Passwords not equal'));
                    }
                } else if (hint !== undefined) {
                    hint.text('');
                }
            }
        });
    }

    // Add event to check password strength of element
    function passwordCheck(element, hint) {
        var checkElement = element.getForCompare ? element.getForCompare() : element;
        $(checkElement).on('input', function () {
            check.call(this, hint);
        });
    }

    function check(hint) {
        var min = ox.guard.getSettings().min_password_length;
        var len = ox.guard.getSettings().password_length;
        if (min === undefined || len === undefined) {
            min = 6;
            len = 10;
        }
        if (len <= min) len = min + 1;
        var el = $(this);
        var val = el.val();
        el.removeClass('oxguard_warnpass').removeClass('oxguard_badpass').removeClass('oxguard_goodpass');
        if (hint !== undefined) {
            hint.removeClass('oxguard_hint_bad').removeClass('oxguard_hint_good').removeClass('oxguard_hint_warn');
        }
        if (val.length === 0) {
            return;
        }
        if (val.length < min) {
            el.addClass('oxguard_badpass');
            if (hint !== undefined) {
                hint.addClass('oxguard_hint_bad').text(gt('Too short'));
            }
            return;
        }
        var regex = /(?=^.{8,}$)(?=.*\d)(?=.*[!@#$%^&*]+)(?![.\n])(?=.*[A-Z])(?=.*[a-z]).*$/;
        if (val.match(regex)) {
            el.addClass('oxguard_goodpass');
            if (hint !== undefined) {
                hint.addClass('oxguard_hint_good').text(gt('Strong'));
            }
            return;
        }
        el.addClass('oxguard_warnpass');
        if (hint !== undefined) {
            hint.addClass('oxguard_hint_warn').text(gt('Weak'));
        }
    }

    // Create password prompt that defeats the autocomplete
    // Depreciated.  Use PasswordView
    function createPasswordInput(id, name, options) {
        if (name === undefined) name = id;
        var passString = '<input ' +
        (name === undefined ? '' : 'name = "' + name + '" ') +
        (id === undefined ? '' : 'id = "' + id + '" ') +
                'type="password" autocomplete="new-password" readonly onfocus="this.removeAttribute(\'readonly\');"' +
        (options === undefined ? '' : options) +
        '/>';
        return $(passString);
    }

    return {
        passwordCheck: passwordCheck,
        passwordCompare: passwordCompare,
        createPasswordInput: createPasswordInput
    };
});
