/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/core/log', [
    'io.ox/core/http'
], function (http) {

    'use strict';

    function log(e, o) {
        var collection = http.log();
        collection.add(new Backbone.Model(e).set({
            params: o.params,
            data: o.data,
            index: collection.length,
            timestamp: _.now(),
            url: o.url
        }));
    }

    function fail(r, url, params, data) {
        var errorText = r.statusText;
        if (r.status === 406 || r.status === 500) {
            errorText = r.status + ': ' + errorText + ' - ' + r.responseText;
            r.status = undefined;
        }
        var e = {
            error: errorText,
            status: r.status
        };
        var o = {
            params: params,
            url: url,
            data: data
        };
        log(e, o);
    }

    function slow(took, url, params, data) {
        var e = { error: 'Took: ' + (Math.round(took / 100) / 10) + 's', status: 200, took: took };
        var o = {
            params: params,
            url: url,
            data: data
        };
        log(e, o);
    }

    return {
        fail: fail,
        slow: slow
    };
});
