/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/core/confirmView', [
    'oxguard/api/keys',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (keysAPI, ModalDialog, core, gt) {

    'use strict';

    // callers
    // - settings -> guard -> Autocrypt keys -> delete

    var POINT = 'oxguard/core/confirmView';

    function open(text, data) {

        return new ModalDialog({
            async: true,
            point: POINT,
            title: gt('Confirmation Required'),
            width: 400,
            model: new Backbone.Model(data)
        })
        .build(function () {
            this.$body.append(
                $('<span>').append(text)
            );
        })
        .addButton({ label: gt('Delete'), action: 'delete' })
        .addCancelButton()
        .on('delete', function () {
            var data = this.model.toJSON();
            core.metrics('settings', 'delete-public-key');
            return keysAPI.deleteExternalPublicKey(data.id, data.keyType).always(function () {
                this.idle();
                this.close();
            }.bind(this));
        })
        .open();
    }

    return {
        open: open
    };

});
