package com.openexchange.guard.servlets.guest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.google.gson.JsonObject;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.common.session.GuardUserSession;
import com.openexchange.guard.guestreset.GuestResetService;
import com.openexchange.guard.inputvalidation.EmailValidator;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.servlets.GuardServletAction;

public class ResetGuardAccountAction extends GuardServletAction {

    @Override
    protected void doActionInternal(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession) throws Exception {
        GuestResetService resetService = Services.getService(GuestResetService.class);
        String email = new EmailValidator().assertInput(ServletUtils.getStringParameter(request, "user", true), "user");
        Integer templid = ServletUtils.getIntParameter(request, "templid");
        if(templid == null) {
            templid = 0;
        }
        String host = request.getServerName();
        resetService.reset(email, host, false, ServletUtils.getClientIP(request));
        JsonObject json = new JsonObject();
        json.addProperty("data", "OK");;
        ServletUtils.sendJsonOK(response, json);
    }

}
