/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.auth;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.JsonObject;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.common.util.JsonUtil;
import com.openexchange.guard.common.util.LocaleUtil;
import com.openexchange.guard.email.storage.ogEmail.EmailStorage;
import com.openexchange.guard.handler.ResponseHandler;
import com.openexchange.guard.inputvalidation.EmailValidator;
import com.openexchange.guard.keymanagement.commons.GuardKeys;
import com.openexchange.guard.keymanagement.services.GuardKeyService;
import com.openexchange.guard.keymanagement.services.KeyCreationService;
import com.openexchange.guard.keymanagement.services.KeyRecoveryService;
import com.openexchange.guard.keymanagement.services.MasterKeyService;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.oxapi.Api;
import com.openexchange.guard.oxapi.OxCookie;
import com.openexchange.guard.ratifier.GuardRatifierService;

/**
 * {@link CreateKeysHandler}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 * @deprecated Use {@link com.openexchange.guard.servlets.keymanagement.actions.CreateKeyPairAction} and {@link com.openexchange.guard.keymanagement.services.KeyCreationService} instead
 */
@Deprecated
public class CreateKeysHandler {

    private static Logger LOG = LoggerFactory.getLogger(CreateKeysHandler.class);

    private String sanitize(String data) throws OXException {
        GuardRatifierService ratifierService = Services.getService(GuardRatifierService.class);
        return ratifierService.normalise(data);
    }


    public void createKeys(HttpServletRequest request, HttpServletResponse response, int userid, int cid, OxCookie cookie) throws Exception {
        JsonObject json = Services.getService(ResponseHandler.class).getJsonAndDecodeEncryptedPasswords(request, userid, cid);
        Api ap = new Api(cookie, request);
        if (ap.verifyLogin() == false) {
            LOG.error("Create keys but not logged into UI");
            response.setStatus(550);
            return;
        }
        LOG.debug("Starting to create master key");
        EmailStorage emailStorage = Services.getService(EmailStorage.class);
        String language = JsonUtil.getStringFromJson(json, "language");
        Locale locale = LocaleUtil.getLocalFor(language);
        String password = JsonUtil.getStringFromJson(json, "password", true);

        GuardKeyService keyService = Services.getService(GuardKeyService.class);
        KeyCreationService keyCreationService = Services.getService(KeyCreationService.class);
        GuardKeys keys = keyService.getKeys(userid, cid);
        KeyRecoveryService recoveryService = Services.getService(KeyRecoveryService.class);
        if (keys == null) {// make sure already don'e exist
            String email = emailStorage.getEmail(userid, cid);
            // Check we don't already have keys for that email
            GuardKeys prevKey = keyService.getKeys(email);
            if (prevKey != null) {
                LOG.error("Attempting to create keys that exist in other context");
                ServletUtils.sendNotAcceptable(response, "Existing");
                return;
            }
            String name = email;
            if (json.get("name") != null) {
                name = json.get("name").getAsString();
            }
            name =  sanitize(name);


            keys = keyCreationService.create(userid, cid, name, email, password, locale, true, recoveryService.checkCreateRecovery(cid, userid));
            keys = keyService.storeKeys(keys, true);

            if (keys == null) {
                LOG.debug("Failed to create master key");
                response.getWriter().write(" {\"result\":\"fail \"} ");
            } else {
                if (json.has("email") && !json.get("email").getAsString().isEmpty()) {
                    String recEmail = new EmailValidator().assertInput(json.get("email").getAsString(), "email");
                    keyService.storeQuestion(userid, cid, "e", recEmail);
                }
                LOG.debug("Created master key for user");
                JsonObject resp = new JsonObject();
                resp.addProperty("result", "ok");
                ServletUtils.sendJsonOK(response, resp);
            }
        } else {// Keys already exist, adding additional
            boolean adding = ServletUtils.getBooleanParameter(request, "add", false);
            if (adding) {
                String email = emailStorage.getEmail(userid, cid);
                String name = email;
                if (json.get("name") != null) {
                    name = json.get("name").getAsString();
                }
                name = sanitize(name);
                GuardKeys newkey = keyCreationService.create(userid, cid, name, email, password, locale, true, recoveryService.checkCreateRecovery(cid, userid));
                keyService.addNewKey(newkey);
                keyService.updateSettingsForUser(keys);
                MasterKeyService mKeyService = Services.getService(MasterKeyService.class);
                newkey.setQuestion(keys.getQuestion());
                if (mKeyService != null) {
                    String decrypted = mKeyService.getRcDecrypted(keys.getAnswer(), keys.getQuestion(), keys.getMasterKeyIndex());
                    newkey.setAnswer(mKeyService.getRcEncryted(decrypted, keys.getQuestion(), newkey.getMasterKeyIndex()));
                }
                keyService.updateAnswerQuestionForUser(newkey);
                LOG.info("Added additional key for user");
                JsonObject resp = new JsonObject();
                resp.addProperty("result", "ok");
                ServletUtils.sendJsonOK(response, resp);
            } else {
                LOG.info("Fail creating key, already exists and add flag not set");
                ServletUtils.sendNotAcceptable(response, "Existing");
                return;
            }

        }
    }


}
