/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.WritableByteChannel;
import com.openexchange.exception.OXException;
import com.openexchange.guard.milter.actions.MilterEOBAction;
import com.openexchange.guard.milter.actions.MilterRcptAction;
import com.openexchange.guard.milter.internal.MilterPacket;
import com.openexchange.guard.milter.service.impl.GuardMilterMail;

/**
 * {@link MilterHandlerService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public interface MilterHandlerService {

    public void reset();

    /**
     * Handles the recipients list
     * @param packet
     * @return
     * @throws OXException
     */
    public MilterResponse rcptTo (MilterPacket packet) throws OXException;

    /**
     * Handles each header
     * @param packet
     * @return
     */
    public MilterResponse header (MilterPacket packet);

    /**
     * Handles the incoming body
     * @param packet
     * @return
     */
    public MilterResponse body (MilterPacket packet);

    /**
     * Marks the end of the data stream.
     * Here any actions needed should take place
     * @param packet
     * @param channel
     * @return
     * @throws IOException
     * @throws UnsupportedEncodingException
     */
    public MilterResponse handleEOB (MilterPacket packet, WritableByteChannel channel) throws UnsupportedEncodingException, IOException;

    public GuardMilterMail getMail ();

    public void addRcptAction (MilterRcptAction action);

    public void addEOBAction (MilterEOBAction action);


}
