/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.server;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;

/**
 * {@link MilterServerWatcher}
 *
 * Thread to watch for new milter connections
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class MilterServerWatcher implements Runnable {

    Logger Log = org.slf4j.LoggerFactory.getLogger(MilterServerWatcher.class);
    private ServerSocketChannel socket = null;
    private boolean running = true;

    public MilterServerWatcher (ServerSocketChannel socket) {
        this.socket = socket;
        this.running = true;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            SocketChannel connection = null;
            try {
                connection = this.socket.accept();
                Thread conThread = new Thread(
                    new MilterConnection(connection)
                    );
                conThread.setName("Milter Connection");
                conThread.start();
            } catch (IOException e) {
                Log.error("Error starting connection ", e);
                return;
            }
        }
    }

}
