/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.guestreset.storage;

import java.util.Date;
import com.openexchange.guard.common.util.CipherUtil;


public class Token {

    private String token;

    private int userid;

    private int cid;

    private Date created;

    private String email;

    public Token (String token, String email, int id, int cid, Date created) {
        this.token = token;
        this.email = email;
        this.userid = id;
        this.cid = cid;
        this.created = created;
    }

    public Token(String email, int id, int cid) {
        this.email = email;
        this.token = CipherUtil.getUUID();
        this.userid = id;
        this.cid = cid;
        this.created = new Date();
    }

    public String getToken () {
        return token;
    }

    public String getEmail () {
        return email;
    }

    public int getUserId () {
        return userid;
    }

    public int getContextId () {
        return cid;
    }

    public Date getCreated() {
        return created;
    }
}
