/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.guest.redirector;

import com.openexchange.exception.OXException;

/**
 * {@link GuestRedirectorService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public interface GuestRedirectorService {

    /**
     * Adds a redirect after a guest user has been upgraded
     * @param userid
     * @param cid
     * @param redirect  URL to redirect future guest logins
     * @throws OXException
     */
    public void addRedirect (int userId, int contextId, String redirect) throws OXException;

    /**
     * Retrieve any existing redirects.  Returns null if not found
     * @param userid
     * @param cid
     * @return redirect.  Null if none found
     * @throws OXException
     */
    public String getRedirect (int userId, int contextId) throws OXException;

    /**
     * Deletes a guest redirect
     * @param userid
     * @param cid
     * @throws OXException
     */
    public void deleteRedirect (int userId, int contextId) throws OXException;


}
