/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.guest.impl.converters;

import java.io.InputStream;
import java.io.OutputStream;
import com.openexchange.exception.OXException;
import com.openexchange.guard.user.UserIdentity;

/**
 * {@link GuestItemConverter} provides an interface for converting and manipulating guest email data
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public interface GuestItemConverter {

    /**
     * {@link GuestItemConverterResult} represents a conversion result
     *
     * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
     * @since v7.10.0
     */
    public enum GuestItemConverterResult {

        /**
         * The item was not converted, because it conversion was not necessary.
         */
        NOT_CONVERTED_NOT_NECASSARY,

        /**
         * The item was converted successfully
         */
        CONVERTED
    }

    /**
     * Converts guest email data into another format.
     *
     * @param guestIdentity A guest which wants to convert the item.
     * @param guestEmailData The guest email to convert into another format
     * @param output The output stream to write the converted data to.
     * @param objectId on the guest email
     * @return The conversion result as {@link GuestItemConverterResult}
     * @throws OXException if an error occurred during conversion.
     */
    GuestItemConverterResult convert(UserIdentity guest, InputStream guardGuestData, OutputStream output, String objectId) throws OXException;
}
