/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.guest;

import javax.mail.internet.MimeMessage;
import com.openexchange.exception.OXException;
import com.openexchange.guard.caching.GenericCache;
import com.openexchange.guard.caching.GenericCacheFactory;
import com.openexchange.guard.email.storage.ogEmail.Email;
import com.openexchange.guard.guest.metadata.storage.GuardGuestEmailMetadata;

/**
 * A caching service to keep in local memory Guest items such as metaData, emails, and mappings
 * {@link GuestCacheService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 * @deprecated Use {@link GenericCache} and {@link GenericCacheFactory} instead.
 */
@Deprecated
public interface GuestCacheService {

    /**
     * Gets the metaData for an itemId if exists in cache
     * @param contextId
     * @param userId
     * @param itemId
     * @return
     * @throws OXException
     */
    public GuardGuestEmailMetadata getMetaData(int contextId, int userId, String itemId) throws OXException;

    /**
     * Adds the meta data to the cache for specific itemId
     * @param contextId
     * @param userId
     * @param itemId
     * @param meta
     * @throws OXException
     */
    public void addMetaData(int contextId, int userId, String itemId, GuardGuestEmailMetadata meta) throws OXException;

    /**
     * Saves a guest message to the cache
     * @param contextId
     * @param itemId
     * @param msg
     * @throws OXException
     */
    public void putMessage (int contextId, String itemId, MimeMessage msg) throws OXException;

    /**
     * Gets a cached message from the cache.  Null if not found
     * @param contextId
     * @param itemId
     * @return
     * @throws OXException
     */
    public MimeMessage getMessage (int contextId, String itemId) throws OXException;

    /**
     * Gets a reference from an OX Guest userid/context to a Guard account
     * @param contextId
     * @param userId
     * @return
     * @throws OXException
     */
    public Email getGuest(int contextId, int userId) throws OXException;

    /**
     * Puts a reference from an OX Guest userid/context to a Guard account
     * @param contextId
     * @param userId
     * @param email
     * @throws OXException
     */
    public void putGuest(int contextId, int userId, Email email) throws OXException;
}
