/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

module.exports = function (grunt) {

    grunt.config.merge({ concat: {
        thirdparty: {
            options: {
                banner: 'var root = {};\ndefine("static/3rd.party/mailbuild.js", function () {\n\n' +
                        '"use strict";\n\n' +
                        'var define = undefined;\n' +
                        'var exports = undefined;\n' +
                        'var global = undefined;\n' +
                        '//this is bound to the "root" variable from above\n' +
                        'this.TextEncoder = window.TextEncoder;\n' +
                        'this.TextDecoder = window.TextDecoder;\n' +
                        'this.btoa = window.btoa;\n',
                footer: 'return this;\n}.bind(root));',
                process: function (src, file) {
                    //FIXME: remove this function, once mailbuild@>0.3.6 is released (see https://github.com/whiteout-io/mailbuild/pull/15)
                    //HACK: HACK HACK HACK
                    if (file !== 'node_modules/mailbuild/src/mailbuild.js') return src;

                    return src.replace(/root.mailbuild = factory\(mimefuncs, mimetypes, punycode, addressparser\);/,
                        'root.mailbuild = factory(root.mimefuncs, root.mimetypes, root.punycode, root.addressparser);')
                              .replace(/return mimefuncs.mimeWordEncode\(name, 'Q', 52\);/,
                                  'return mimefuncs.mimeWordEncode(name, "B", 52);');
                }
            },
            files: [{
                src: [
                    'node_modules/mimefuncs/src/mimefuncs.js',
                    'node_modules/mimetypes/src/mimetypes.js',
                    'node_modules/punycode/punycode.js',
                    'node_modules/wo-addressparser/src/addressparser.js',
                    'node_modules/mailbuild/src/mailbuild.js'
                ],
                dest: 'build/static/3rd.party/mailbuild.js'
            }]
        }
    } });
};
