/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

module.exports = function (grunt) {

    grunt.config.merge({
        concat: {
            bundle: {
                options: {
                    footer: 'define("oxguard/bundle",["oxguard/register"],_.noop);'
                },
                files: [{
                    src: [
                        'apps/oxguard/oxguard_register.js',
                        'apps/oxguard/oxguard_core.js',
                        'apps/oxguard/core/og_http.js',
                        'apps/oxguard/settings/defaults.js',
                        'apps/oxguard/mail/maillist.js',
                        'apps/oxguard/mail/register.js',
                        'apps/oxguard/mail/checker.js',
                        'apps/oxguard/mail/mailReplyActions.js',
                        'apps/oxguard/mail/oxguard_mail_password.js',
                        'apps/oxguard/mail_lock/util.js',
                        'apps/oxguard/mail/mail_metrics.js',
                        'apps/oxguard/mail/register_compose.js',
                        'apps/oxguard/mail/oxguard_mail_compose_core.js',
                        'apps/oxguard/util.js',
                        'apps/oxguard/mail_lock/toggle-encryption.js',
                        'apps/oxguard/auth.js',
                        'apps/oxguard/core/passwordView.js',
                        'build/apps/oxguard/crypto/encr.js',
                        'build/apps/oxguard/crypto/jsencrypt.js',
                        'build/apps/oxguard/oxguard_data.js'
                    ],
                    dest: 'build/apps/oxguard/bundle.js'
                }]
            }
        }
    });
};
