/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Settings - Defaults');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

const assert = require('chai').assert;

var optionsDropdown = locate({ css: '[data-extension-id="composetoolbar-menu"] a[aria-label="Options"]' }).as('Options dropdown');

Scenario('Default encrypted works', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);  // need advanced settings

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    // Next, log in to settings
    await I.goToSettings();

    I.waitForVisible('.guardDefaults .checkbox');
    I.click('Default to send encrypted when composing email');
    I.wait(1);
    I.openApp('Mail');
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');
    I.click('Compose');
    I.waitForVisible('#ogPassword');  // make sure password prompt displayed

});

Scenario('Default signature works', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);  // need advanced settings

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    // Next, log in to settings
    await I.goToSettings();

    I.waitForVisible('.guardDefaults .checkbox');
    I.click('Default adding signature to outgoing mails');
    I.wait(1);
    I.openApp('Mail');
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');
    I.click('Compose');
    I.waitForVisible('.window-blocker.io-ox-busy');
    I.waitForInvisible('.window-blocker.io-ox-busy');
    I.click(optionsDropdown);
    I.waitForElement('[data-name="sign"][aria-checked="true"]');
});

Scenario('Default sign and encrypt works', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    await I.setupUser(o, true);  // need advanced settings

    I.login('app=io.ox/mail', o);
    await I.verifyUserSetup(userdata);

    // Next, log in to settings
    await I.goToSettings();

    I.waitForVisible('.guardDefaults .checkbox');
    I.click('Default to send encrypted when composing email');
    I.click('Default adding signature to outgoing mails');
    I.wait(1);
    I.openApp('Mail');
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');
    I.click('Compose');
    I.waitForVisible('.window-blocker.io-ox-busy');
    I.waitForInvisible('.window-blocker.io-ox-busy');
    I.waitForVisible('#ogPassword');
    I.fillField('#ogPassword', userdata.password);
    I.click('.btn[data-action="ok"]');
    I.waitForInvisible('.modal-dialog');
    I.click(optionsDropdown);
    I.waitForElement('[data-name="sign"][aria-checked="true"]');
});
