/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Remembering Passwords');

Before(async function (users) {
    await users.create();
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Decrypt multiple emails with one password', async function (I, users) {

    const count = 4;  // number of emails
    const o = {
        user: users[0]
    };
    const user = o.user, userdata = o.user.userdata;

    I.login('app=io.ox/mail', o);

    await I.verifyUserSetup(userdata);

    for (var i = 0; i < count; i++ ){ 
        await I.haveMail({
            attachments: [{
                content: 'Test content ' + i,
                content_type: 'text/html',
                disp: 'inline'
            }],
            from: [[user.get('display_name'), user.get('primaryEmail')]],
            sendtype: 0,
            subject: 'Test subject ' + i,
            to: [[user.get('display_name'), user.get('primaryEmail')]],
            security: {
                encrypt: true,
                sign: false,
                type: 'pgp'
            }
        });
    }
    I.waitForElement('#io-ox-refresh-icon .fa-spin');
    I.waitForDetached('#io-ox-refresh-icon .fa-spin');
    I.click('#io-ox-refresh-icon');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');

    let subj = await I.grabTextFrom('.unread .subject .drag-title');
    I.click('.list-item.unread');   // click one email

    I.waitForElement('.og_password input.form-control.password_prompt');
    I.insertCryptPassword('.og_password input.form-control.password_prompt', userdata);
    I.click('#rememberpass');
    I.click('.btn.oxguard_passbutton');

    I.verifyDecryptedMail(subj[0], subj[0].replace('subject', 'content'), false);

    for (var j = 1; j < count; j++) {
        subj = await I.grabTextFrom('.unread .subject .drag-title');
        I.click('.list-item.unread');
        var subject = Array.isArray(subj) ? subj[0] : subj;
        I.verifyDecryptedMail(subject, subject.replace('subject', 'content'), false);
    }
    

});