/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Test signatures');

Before(async function (users) {
    await users.create();
    await users.create();  // Two users
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Send signed non-encrypted email', async function (I, users) {
    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup
    
    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata2, subject, data, undefined, { unencrypted: true, sign: true });

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', o2);
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    I.waitForVisible('.guard_signed');  // Verify PGP icon
    I.waitForVisible('.mail-detail-frame');
    I.switchTo('.mail-detail-frame');
    I.see(data);  // Check data in body
    I.switchTo();

    // OK, done
    I.logout();
});

Scenario('Send signed and encrypted email', async function (I, users) {
    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup
    
    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata2, subject, data, undefined, { sign: true });

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', o2);
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Change temporary password
    I.changeTemporaryPassword(userdata2);

    I.waitForVisible('.btn[data-action="done"]');  // Wizard shows done
    I.click('.btn[data-action="done"]');

    // Verify decrypted
    I.verifyDecryptedMail(subject, data, true);

    // OK, done
    I.logout();
});

Scenario('Send signed and encrypted inline email', async function (I, users) {
    const o1 = {
        user: users[0]
    };
    const o2 = {
        user: users[1]
    };

    await I.setupUser(o1, true);

    const userdata1 = o1.user.userdata;
    const userdata2 = o2.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.verifyUserSetup(userdata1);  // Verify user has Guard setup
    
    // Test data
    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    // Open compose
    I.sendEmail(userdata2, subject, data, undefined, { sign: true, inline: true });

    I.wait(2);

    // Logout and log back in as second user
    I.logout();
    I.login('app=io.ox/mail', o2);
    I.waitForVisible('.io-ox-mail-window .leftside');
    I.waitForVisible('.io-ox-mail-window .leftside ul li.unread');
    I.click('.io-ox-mail-window .leftside ul li.unread');

    // Change temporary password
    I.changeTemporaryPassword(userdata2);

    I.waitForVisible('.btn[data-action="done"]');  // Wizard shows done
    I.click('.btn[data-action="done"]');

    // Verify decrypted
    I.verifyDecryptedMail(subject, data, true);

    // OK, done
    I.logout();
});
