/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Smime with PGP');

Before(async function (users) {
    await users.create().then(async function (user) {
        await user.hasCapability('smime');
    });
    
});

After(async function (users) {
    await users.removeAll();
});

Scenario('Able to select between smime and pgp', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    var optionsDropdown = locate({ css: '[data-extension-id="composetoolbar-menu"] a[aria-label="Options"]' }).as('Options dropdown');

    await I.haveSetting('oxguard//smime', true, { user: o.user, noCache: true });

    // Log in as User 0
    I.login('app=io.ox/mail', o);
    I.waitForVisible('.io-ox-mail-window .window-body');

    
    await I.verifyUserSetup(userdata);  // Verify user has Guard setup
    await I.setupSmimeKey(o.user);

    var random = Math.floor((Math.random() * 100000));
    var subject = "Test Subject " + random;
    var data = "Test data " + random;

    I.sendEmail(userdata, subject, data, undefined, { smime: true, dontsend: true });

    I.waitForVisible('i.fa-key');
    I.moveCursorTo('i.fa-key', 5, 5);
    I.waitForVisible('.tooltip');
    I.see('S/MIME', '.tooltip');

    I.click(optionsDropdown);
    I.waitForText('Use PGP', 10, '.dropdown.open .dropdown-menu');
    I.click('Use PGP');

    I.waitForVisible('#ogPassword');
    I.fillField('#ogPassword', userdata.password);
    I.click('.btn[data-action="ok"]');

    I.waitForVisible('i.fa-key');
    I.moveCursorTo('i.fa-key', 5, 5);
    I.waitForVisible('.tooltip');
    I.see('System key', '.tooltip');

});
