/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Drive - File Sharing');

Before(async function (users) {
    await users.create();
    await users.create();  // Second user for revoke test
});

After(async function (users) {
    await users.removeAll();
});

const assert = require('chai').assert;

Scenario('Share an encrypted file', async function (I, users) {
    if (await I.amDisabled('drive')) return;
    const o = {
        user: users[0],
        cryptoAction: 'encrypt'
    };
    const o2 = {
        user: users[1]
    };
    // Make sure second user setup
    I.login('app=io.ox/files', o2);
    await I.verifyUserSetup(o2.user.userdata);
    I.logout();

    // Login as first user, and setup
    const userdata = o.user.userdata;
    const infostoreFolderID = await I.grabDefaultFolder('infostore');

    I.login('app=io.ox/files', o);
    
    await I.verifyUserSetup(userdata);
    let fileId = await I.haveFile(infostoreFolderID, 'e2e/testFiles/simpleText.txt', o);
    let id = fileId.folder_id + '.' + fileId.id;

    // OK, let's share
    I.wait(1);
    I.waitForVisible('.apptitle[aria-label="Refresh"]');
    I.click('.apptitle[aria-label="Refresh"]');
    I.waitForVisible('.list-view li[data-cid="' + id + '"]');
    I.click('.list-view li[data-cid="' + id + '"]');
    I.wait(1);
    I.waitForVisible('a[data-action="io.ox/files/actions/invite"]');
    I.click('a[data-action="io.ox/files/actions/invite"]');
    I.auth(userdata);
    I.waitForVisible('.tt-input');
    I.click('.tt-input');
    I.wait(1);
    I.fillField('.tt-input', o2.user.userdata.email1);
    I.wait(1);
    I.pressKey('Tab');  // remove focus
    I.wait(1);
    I.click('.btn-primary[data-action="save"]');  // share
    I.waitForInvisible('.modal-content');
    I.logout();

    I.login('app=io.ox/files', o2);
    I.waitForElement('.file-list-view.complete');
    I.wait(1);
    I.selectFolder('Shared files');
    I.waitForInvisible('.window-blocker.io-ox-busy');
    I.waitForVisible('.file-type-guard');
    I.see('simpleText.txt.pgp', '.list-view');

    // Now, try decrypting/viewing
    I.doubleClick('.file-type-guard');
    I.auth(o2.user.userdata);

    I.waitForVisible('.white-page.plain-text', 15);
    let content = await I.grabTextFrom('.white-page.plain-text');
    assert.include(content, 'simple text', 'Decrypted data content');

    // Cleanup
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.wait(1);
    I.logout();



});