/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Drive - Encrypt-Decrypt');

Before(async function (users) {
    await users.create();
    await users.create();  // Second user for revoke test
});

After(async function (users) {
    await users.removeAll();
});

const assert = require('chai').assert;

Scenario('Mobile: Encrypt and then view a file', async function (I, users) {
    if (await I.amDisabled('drive')) return;
    if (await I.amDisabled('mobile')) return;
    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    const infostoreFolderID = await I.grabDefaultFolder('infostore');
    let fileId = await I.haveFile(infostoreFolderID, 'e2e/testFiles/simpleText.txt', o);
    let id = fileId.folder_id + '.' + fileId.id;

    await I.openMobile();
    I.login('app=io.ox/files', o);
    
    await I.verifyUserSetup(userdata);

    // Encrypt the file
    I.waitForVisible('.list-view li[data-cid="' + id + '"]');
    I.tap('.list-view li[data-cid="' + id + '"] .list-item-checkmark');
    I.wait(1);
    I.click('.dropdown-toggle[data-action="more"]');
    I.click('.dropdown-menu [data-action="oxguard/encrypt"]');
    I.wait(1);
    I.waitForVisible('.file-type-guard');
    I.see('simpleText.txt.pgp', '.list-view');

    // Now, try decrypting/viewing
    I.tap('.file-type-guard');
    I.auth(userdata);

    I.waitForVisible('.white-page.plain-text');
    let content = await I.grabTextFrom('.white-page.plain-text');
    assert.include(content, 'simple text', 'Decrypted data content');

    // Cleanup
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.wait(1);
    I.logout();
});

Scenario('Desktop: Encrypt and then view a file', async function (I, users) {
    if (await I.amDisabled('drive')) return;
    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    const infostoreFolderID = await I.grabDefaultFolder('infostore');
    let fileId = await I.haveFile(infostoreFolderID, 'e2e/testFiles/simpleText.txt', o);
    let id = fileId.folder_id + '.' + fileId.id;

    I.login('app=io.ox/files', o);
    
    await I.verifyUserSetup(userdata);

    // Encrypt the file
    I.waitForVisible('.list-view li[data-cid="' + id + '"]');
    I.click('.list-view li[data-cid="' + id + '"]');
    I.wait(1);
    I.click('.dropdown-toggle[data-action="more"]');
    I.click('.dropdown-menu [data-action="oxguard/encrypt"]');
    I.wait(1);
    I.waitForVisible('.file-type-guard');
    I.see('simpleText.txt.pgp', '.list-view');

    // Now, try decrypting/viewing
    I.doubleClick('.file-type-guard');
    I.auth(userdata);

    I.waitForVisible('.white-page.plain-text');
    let content = await I.grabTextFrom('.white-page.plain-text');
    assert.include(content, 'simple text', 'Decrypted data content');

    // Cleanup
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
});

Scenario('Remove encryption and then view a file', async function (I, users) {
    if (await I.amDisabled('drive')) return;
    const o = {
        user: users[0],
        cryptoAction: 'encrypt'
    };
    const userdata = o.user.userdata;
    const infostoreFolderID = await I.grabDefaultFolder('infostore');

    I.login('app=io.ox/files', o);
    
    await I.verifyUserSetup(userdata);
    let fileId = await I.haveFile(infostoreFolderID, 'e2e/testFiles/simpleText.txt', o);
    let id = fileId.folder_id + '.' + fileId.id;
    I.wait(1);
    I.click('#io-ox-refresh-icon');
    // Encrypt the file
    I.waitForVisible('.list-view li[data-cid="' + id + '"]');
    I.click('.list-view li[data-cid="' + id + '"]');
    I.wait(1);
    I.click('.dropdown-toggle[data-action="more"]');
    I.click('.dropdown-menu [data-action="oxguard/remencrypt"]');
    I.auth(userdata);
    I.waitForVisible('.file-type-txt');
    I.see('simpleText.txt', '.list-view');

    // Now, try decrypting/viewing
    I.doubleClick('.file-type-txt');
    I.waitForVisible('.white-page.plain-text');
    let content = await I.grabTextFrom('.white-page.plain-text');
    assert.include(content, 'simple text', 'Decrypted data content');

    // Cleanup
    I.click('.classic-toolbar [data-action="io.ox/core/viewer/actions/toolbar/close"]');
    I.wait(1);
    I.logout();
});

