/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/**
 * This sends a new email to recipient
 */

module.exports  = function (userdata, subject, data, attachment, options) {

        options = options || {};

       // Open compose
       this.wait(2);
       this.click('.inline-toolbar [data-action="io.ox/mail/actions/compose"]');
       this.waitForVisible('.window-blocker.io-ox-busy');
       this.waitForInvisible('.window-blocker.io-ox-busy');
       this.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');
   
       // Mark as secure unless specified as non-encrypted
       if (!options.unencrypted) {
        this.click('Security');
        this.waitForVisible('.dropdown-menu a[data-name="encrypt"]');
        if (options.smime) {
             this.click('Secure');
        } else {
          this.click('Encrypt');
          this.waitForVisible('#ogPassword');
          this.fillField('#ogPassword', userdata.password);
          this.click('.btn[data-action="ok"]');
        }
       }

       if (options.attachKey) {
          this.click('Security');
          this.waitForVisible('.dropdown-menu a[data-name="PubKey"]');
          this.click('Attach my key');
       }

       if (options.sign) {
        this.click('Security');
        this.waitForVisible('.dropdown-menu a[data-name="PGPSignature"]');
        this.click('Sign');
       }
  

       if (options.inline) {
        this.wait(1);
        this.click('Security');
        this.waitForVisible('.dropdown-menu a[data-name="pgpInline"]');
        this.click('.dropdown-menu a[data-value="true"]');
        this.waitForVisible('.btn[data-action="okx"]');
        this.click('.btn[data-action="okx"]');
        this.waitForInvisible('.modal-backdrop');
       }
   
       // Insert test data
       this.fillField('.io-ox-mail-compose div[data-extension-id="to"] input.tt-input', userdata.email1);
       this.fillField('.io-ox-mail-compose [name="subject"]', subject);
       var I = this;

       if (options.inline) {  // Inline plaintext only
            I.fillField('.plain-text', data);
       } else {
            within({ frame: '.io-ox-mail-compose-window .editor iframe' }, async () => {
              I.fillField('.mce-content-body', data);
            });
       }

       // Attachments if any
       if (attachment) {
            this.attachFile('.composetoolbar input[type="file"]', attachment);  
            this.wait(2); 
       }
   
       // Verify key is next to recipient names
       if (!options.unencrypted) {
            this.waitForVisible('i.fa.fa-key.oxguard_token.key_tooltip.trusted_key');
            // Send
            if (options.smime) {
                 this.click('Send Secure');
            } else {
                 this.click('Send Encrypted');
            }
            
       } else {
           this.click('Send');
       }

       if (options.sign) {
           this.waitForVisible('#ogPassword');
           this.fillField('#ogPassword', userdata.password);
           this.click('.btn[data-action="ok"]');
       }
       this.waitForVisible('.inline-toolbar [data-action="io.ox/mail/actions/compose"]');
       I.waitForInvisible('.mail-progress');
   
};