/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/selectTypeView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'settings!oxguard',
    'less!oxguard/settings/style'
], function (ext, ModalView, core, gt, settings) {

    'use strict';

    var POINT = 'oxguard/settings/selectType',
        INDEX = 0;

    function open(o) {
        if (!core.hasSmime() || (core.hasGuard() && !settings.get('smime'))) {
            return o.pgpAction();
        }
        if (!core.hasGuard()) {
            return o.smimeAction();
        }
        var def = $.Deferred();
        openModalDialog(o.title, o.pgpAction, o.smimeAction, def);
        return def;
    }

    function openModalDialog(title, pgpAction, smimeAction, def) {

        return new ModalView({
            async: true,
            point: POINT,
            title: title ? title : gt('Select type to use'),
            width: 500,
            class: 'cryptoSelector',
            model: new Backbone.Model({ title: title, pgpAction: pgpAction, smimeAction: smimeAction, def: def })
        })
        .inject({
        })
        .build(function () {
        })
        .addCancelButton()
        .open();
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'PGP',
            render: function (baton) {
                var def = baton.model.get('def');
                var doAction = function () {
                    var pgpAction = baton.model.get('pgpAction');
                    baton.view.close();
                    getDef(pgpAction).then(def.resolve, def.reject);
                };
                var div = $('<div class="cryptoTypeDiv">').on('click', doAction);
                var innerDiv = $('<div style="width: 100%">');
                var label = $('<label for="PGPButton">').append(gt('PGP (The default type for %s).', ox.guard.getName()));
                var button = $('<button type="button" class="btn btn-primary" id="PGPButton">')
                    .text(gt('PGP'))
                    .on('click', doAction);
                this.$body.append(
                    div.append(innerDiv.append(label).append(button))
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'SMIME',
            render: function (baton) {
                var def = baton.model.get('def');
                var doAction = function () {
                    var smimeAction = baton.model.get('smimeAction');
                    baton.view.close();
                    getDef(smimeAction).then(def.resolve, def.reject);
                };
                var div = $('<div class="cryptoTypeDiv">').on('click', doAction);
                var innerDiv = $('<div style="width: 100%">');
                var label = $('<label for="smimeButton">').append(
                    gt('S/MIME'));
                var button = $('<button type="button" class="btn btn-primary" id="smimeButton">')
                    .text(gt('S/MIME'))
                    .on('click', doAction);
                this.$body.append(
                    div.append(innerDiv.append(label).append(button))
                );
            }
        }
    );

    function getDef(action) {
        var def = action();
        if (def && def.then) {
            return def;
        }
        return $.when();
    }

    return {
        open: open
    };
});
