/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deletePublicView', [
    'io.ox/backbone/views/modal',
    'oxguard/oxguard_core',
    'io.ox/core/yell',
    'oxguard/api/keys',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ModalDialog, core, yell, keysAPI, gt) {

    'use strict';

    function openModalDialog(keyId) {

        return new ModalDialog({
            async: true,
            point: 'oxguard/settings/deletePublic',
            title: gt('Delete Public Key'),
            width: 400,
            enter: 'cancel'
        })
        .build(function () {
            this.$body.append(
                $('<p>').text(gt('Please verify you want to delete this key'))
            );
        })
        .addButton({ label: gt('Delete'), action: 'delete', className: 'btn-default' })
        .addCloseButton()
        .on('delete', function () {
            core.metrics('settings', 'delete-public-key');
            keysAPI.delete(keyId).done(function () {
                yell('success', gt('Key Deleted'));
                this.close();
            }.bind(this));
        })
        .open();
    }

    return {
        open: openModalDialog
    };

});
