/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deletePrivateViewStep2', [
    'io.ox/backbone/views/modal',
    'oxguard/api/keys',
    'oxguard/core/passwordView',
    'oxguard/oxguard_core',
    'io.ox/core/yell',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ModalDialog, keysAPI, PasswordView, core, yell, gt) {

    'use strict';


    function openModalDialog(keyid) {

        return new ModalDialog({
            async: true,
            point: 'oxguard/settings/deletePrivateStep2',
            title: gt('Delete Private Key'),
            width: 640,
            focus: '#deletepass'
        })
        .extend({
            'warning': function () {
                this.$body.append(
                    $('<p class="bg-danger bg-padding">').append(
                        gt('You will no longer be able to decode any items that were encrypted with this key!')
                    )
                );
            },
            'password': function () {
                this.$body.append(
                    $('<label for="deletepass">').text(
                        gt('Your %s password', ox.guard.getName())
                    ),
                    new PasswordView.view({ 'id': 'deletepass' }).getProtected()
                );
            }
        })
        .addButton({ label: gt('Delete'), action: 'delete', className: 'btn-default' })
        .on('delete', function () {
            var dialog = this,
                password = $('#deletepass').val(),
                invalid = password.length <= 1;

            if (invalid) {
                this.idle();
                return yell('info', gt('Please enter your password'));
            }

            core.metrics('settings', 'delete-private-key');
            return keysAPI.delete(keyid, { password: password }).then(function () {
                dialog.close();
            }, function () {
                dialog.idle();
            });
        })
        .addCloseButton()
        .open();
    }

    return {
        open: openModalDialog
    };

});
