/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/deletePrivateView', [
    'io.ox/backbone/views/modal',
    'gettext!oxguard',
    'less!oxguard/settings/style'
], function (ModalDialog, gt) {

    'use strict';


    function openModalDialog(keyid, isMaster) {

        var allowDelete = !ox.guard.getSettings().noDeletePrivate && isMaster;

        return new ModalDialog({
            async: true,
            point: 'oxguard/settings/deletePrivate',
            id: 'delete-private-key',
            title: allowDelete ? gt('Delete Private Key') : gt('Revoke Private Key'),
            width: 640,
            enter: 'cancel',
            keyid: keyid
        })
        //.addCloseButton()
        .extend({
            'options': function () {
                if (!allowDelete) return;
                this.$body.append(
                    $('<p>').text(gt('There are two options if you no longer want to use this key.'))
                );
            },
            'revoke': function () {
                // text
                this.$body.append(
                    $('<p>').append(
                        allowDelete ? $('<h5>').text(gt('Revoke the key')) : $(),
                        $('<span>').text(gt('This advises others that you no longer want this key used. You can continue to decode any encrypted data using the key.')),
                        $.txt(' '),
                        $('<i>').text(gt('Recommended'))
                    )
                );
                // button
                this.addButton({ label: gt('Revoke'), action: 'revoke', className: 'btn-default' })
                    .on('revoke', function () {
                        ox.load(['oxguard/settings/views/revokePrivateView']).then(function (revoke) {
                            revoke.open(this.options.keyid);
                            this.close();
                        }.bind(this));
                    });
            },
            'delete': function () {
                if (!allowDelete) return;

                // text
                this.$body.append(
                    $('<p>').append(
                        $('<h5>').text(gt('Deleting the key')),
                        $('<span>').text(gt('Deleting the private key will render all encrypted items unreadable.  You will not be able to decode emails or files that were enrypted with this key. This will delete this key and any sub-keys. This cannot be undone.'))
                    )
                );
                // button
                this.addAlternativeButton({ label: gt('Delete'), action: 'delete' })
                    .on('delete', function () {
                        ox.load(['oxguard/settings/views/deletePrivateViewStep2']).then(function (view) {
                            view.open(this.options.keyid);
                            this.close();
                        }.bind(this));
                    });
            },
            'close': function () {
                this.addCloseButton();
            }
        })
        .open();
    }

    return {
        open: openModalDialog
    };

});
