/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/settings/views/autoCryptKeysView', [
    'io.ox/backbone/views/modal',
    'oxguard/pgp/keyDetails',
    'gettext!oxguard'
], function (ModalDialog, pubkeys, gt) {

    'use strict';

    function openModalDialog() {

        return new ModalDialog({
            async: true,
            point: 'oxguard/settings/autoCryptkeys',
            title: gt('Autocrypt Keys'),
            id: 'autoCryptList',
            width: 560
        })
        .extend({
            'header': function () {
                this.$header.append(
                    $('<div class="autocryptHeader">').append(
                        $('<span>').append(
                            gt('These keys have been collected from email headers.  Keys are used for encryption, but not signatures verification until the key is verified by you.')
                        )
                    ));
            },
            'list-public': function () {
                this.$el.addClass('maxheight');
                this.$body.append(
                    pubkeys.listPublic({
                        id: 'autoCrypt',
                        title: gt('Collected keys'),
                        minimal: true
                    })
                );
            }
        })
        .addCloseButton()
        .open();
    }

    return {
        open: openModalDialog
    };

});
