/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/settings/smime/deleteSmimeView', [
    'io.ox/core/extensions',
    'io.ox/backbone/views/modal',
    'io.ox/core/yell',
    'oxguard/core/passwordView',
    'gettext!oxguard',
    'oxguard/api/certs',
    'less!oxguard/settings/style'
], function (ext, ModalView, yell, PasswordView, gt, certs) {

    'use strict';

    var POINT = 'oxguard/settings/deleteSmime',
        INDEX = 0;

    function open(keyid) {
        var def = $.Deferred();
        openModalDialog(keyid, def);
        return def;
    }

    function openModalDialog(keyid, def) {

        return new ModalView({
            async: true,
            point: POINT,
            title: gt('Delete Private Key'),
            width: 640,
            focus: '#deletepass'
        })
        .inject({
        })
        .build(function () {
        })
        .addAlternativeButton({ label: gt('Delete'), action: 'delete' })
        .on('delete', function () {
            var dialog = this;
            doDelete(keyid).done(function () {
                dialog.close();
                def.resolve();
            })
            .fail(function (e) {
                dialog.close();
                if (e && e.length > 1) yell('error', e);
                def.reject();
            });
        })
        .on('cancel', function () {
            def.reject();
        })
        .addCloseButton()
        .open();
    }

    ext.point(POINT).extend(
        {
            index: INDEX += 100,
            id: 'header',
            render: function () {
                var label = $('<label style="color:red">').append(gt('You will no longer be able to decode any items that were encrypted with this key!'))
                    .append('<br>');
                this.$body.append(
                    label
                );
            }
        },
        {
            index: INDEX += 100,
            id: 'getPassword',
            render: function () {
                var label = $('<label for="deletepass">').append(
                    gt('Please enter your %s password', ox.guard.getName()))
                    .append('<br>');
                var password = new PasswordView.view({ 'id': 'deletepass' }).getProtected();
                this.$body.append(
                    label.append(password)
                );
            }
        }

    );

    function doDelete(keyid) {
        var def = $.Deferred();
        var pass = $('#deletepass').val();
        if (pass.length > 1) {
            certs.delete(keyid, pass).then(def.resolve, def.reject);
            return def;
        }
        def.reject(gt('Enter password'));
        return def;
    }

    return {
        open: open
    };

});
