/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/settings', [
    'io.ox/core/extensions',
    'oxguard/util',
    'io.ox/core/capabilities'
], function (ext, util, capabilities) {

    'use strict';

    if (util.isGuardConfigured() || capabilities.has('guard-mail') || capabilities.has('guard-drive') || util.hasSmime()) {
        // Add settings for encryption to the Settings Page
        ext.point('io.ox/settings/pane/general/security').extend({
            id: 'oxguard',
            //#. %s product Name
            title: ox.guard.getName(),
            index: 600,
            loadSettingPane: true
        });

        ext.point('io.ox/settings/help/mapping').extend({
            id: 'guardHelp',
            index: 200,
            list: function () {
                _.extend(this, {
                    'virtual/settings/oxguard': {
                        base: 'help',
                        target: 'ox.appsuite.user.sect.guard.settings.html'
                    }
                });
            }
        });

    }

    if (!util.isGuardLoaded()) {
        var removeIfNotNeeded = function () {
            if (!util.isGuardConfigured() && !(capabilities.has('guard-mail') || capabilities.has('guard-drive'))) {
                $('[data-model="virtual/settings/oxguard"]').remove();
            }
        };
        util.addOnLoaded(removeIfNotNeeded);
    }

});
