/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

define('oxguard/portal/register', [
    'io.ox/core/extensions'
], function (ext) {

    'use strict';

    ////////// Extension point portal

    ext.point('io.ox/portal/widget/myfiles').extend({
        id: 'OxGuardRecentFiles',
        index: 1000000,
        preview: function () {
            var content = $(this).find('.list-unstyled');
            setupGuard(content);
        }
    });

    ext.point('io.ox/portal/widget/recentfiles').extend({
        id: 'OxGuardRecentFiles',
        index: 1000000,
        preview: function () {
            var content = $(this).find('.list-unstyled');
            setupGuard(content);
        }
    });

    function setupGuard(content) {
        content.unbind('click');
        content.on('click', 'li.item', function (e) {
            e.stopPropagation();
            var item = $(e.currentTarget).data('item');
            if (isEncrypted(item)) {
                require(['oxguard/files/register', 'io.ox/files/api'], function (files, filesAPI) {
                    var items = $(e.delegateTarget).data('items');
                    filesAPI.get(item).done(function (data) {
                        var models = filesAPI.resolve(items, false),
                            collection = new Backbone.Collection(models);
                        var baton = new ext.Baton({ data: data, collection: collection });
                        files.viewFile(baton);
                    });
                });
            } else {
                var items = $(e.delegateTarget).data('items');
                require(['io.ox/core/viewer/main', 'io.ox/files/api'], function (Viewer, filesAPI) {
                    filesAPI.get(item).done(function (data) {
                        var models = filesAPI.resolve(items, false),
                            collection = new Backbone.Collection(models),
                            viewer = new Viewer();
                        var baton = new ext.Baton({ data: data, collection: collection });
                        viewer.launch({ selection: baton.data, files: baton.collection.models });
                    });
                });
            }

        });
    }

    function isEncrypted(item) {
        if (item.meta) {
            if (item.meta.Encrypted === true) return (true);
        }
        if (item.filename) {
            if (item.filename.indexOf('.pgp') > 0) return (true);
        }
        return (false);
    }
});
