/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/mail_lock/keyring', [
    'io.ox/core/extensions',
    'less!oxguard/mail_lock/style'
], function (ext) {

    'use strict';

    var RecipientModel = Backbone.Model.extend({
        initialize: function () {
            this.listenTo(this, 'change:email', this.lookup);
            //do initial lookup
            this.lookup(this, this.get('email'));
        },
        defaults: {
            email: '',
            keys: []
        },
        addKey: function (obj) {
            this.set('keys', this.get('keys').concat(obj));
        },
        lookup: function (model, val) {
            if (!val) return;

            var baton = new ext.Baton({
                email: val
            });
            ext.point('oxguard/mail_lock/keyring/lookup').invoke('action', model, baton);
        }
    });

    var RecipientView = Backbone.View.extend({
        initialize: function (opt) {
            this.renderAddress = opt.renderAddress;
            this.listenTo(this.model, 'change:keys', function () {
                this.render();
            });
        },
        tagName: 'span',
        className: 'recipient-state',
        render: function () {
            var state = $('<i class="fa fa-key">');
            var address = '';
            if (this.renderAddress) {
                address = $('<span class="email">').text(this.model.get('email'));
            }
            state.toggleClass('key-found', this.model.get('keys').length > 0);
            var trusted = this.model.get('keys').reduce(function (acc, key) {
                return acc || key.trusted === true;
            }, false);
            state.toggleClass('trusted', trusted);
            this.$el.empty().append(address, state);
            return this;
        }
    });

    var recipients = {
        View: RecipientView,
        Model: RecipientModel
    };

    return {
        recipients: recipients
    };
});
