/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/mail/oxguard_mail_password', [
    'io.ox/core/extensions',
    'oxguard/oxguard_core',
    'oxguard/core/og_http',
    'oxguard/core/passwords',
    'oxguard/core/passwordView',
    'gettext!oxguard',
    'settings!oxguard',
    'less!oxguard/mail/style'
], function (ext, oxguard, http, passwords, PasswordView, gt, guardSettings) {

    'use strict';

    ////////////////////////   RECEIVE / READ

    // Unified inbox combines folder and email ID, returns email id
    function getId(baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1) + (baton.view.cid ? baton.view.cid : '');
        } catch (e) {
            console.error(e);
        }
        return (id);
    }

    function getType(baton) {
        if (baton.data.security_info && baton.data.security_info.type) { return baton.data.security_info.type; }
        return 'unkown';
    }

    function getPrompt(baton) {
        // Generic
        if ((oxguard.hasGuardMail() && !oxguard.hasSmime()) || // Has guard-mail, but not smime
            (oxguard.hasSmime() && !oxguard.hasGuardMail()) || // Has smime, but not guard-mail
            (getType(baton) === 'PGP' && !oxguard.hasSmimeEnabled())) {  // Has both, but type is PGP and doesn't have smime enabled in settings
            return gt('Secure Email, enter your %s security password.', ox.guard.getName());
        }
        if (getType(baton) === 'PGP') {
            return gt('PGP encrypted email, enter the password for the PGP key.');
        }
        if (getType(baton) === 'SMIME') {
            return gt('S/MIME encrypted email, enter the password for the S/MIME key.');
        }
        return gt('Uncertain encryption type');

    }

    function passwordPrompt(baton, badpass, location, goFunction, localOnly) {
        var id = getId(baton);
        var passwordBoxView = new PasswordView.view({ 'id': 'oxgrpass' + id, 'class': 'password_prompt', 'validate': false });
        var passwordbox = passwordBoxView.getProtected().css('display', 'inline');
        var grdPasswordPrompt = $('<div class="alert og_password"/>');
        //#. %s product Name
        var mainpassprompt = $('<label style="font-weight:bold;" for="oxgrpass' + id + '">' + getPrompt(baton) + '</span><br/><div style="height:10px;"/>');
        if (_.device('small')) {
            passwordbox.css('width', '150px');
        }
        var noSaveWorkAround = $('<input style="display:none" type="text" name="dontremember"/><input style="display:none" type="password" name="dontrememberpass"/>');
        var passButton = $('<button class="btn btn-primary oxguard_passbutton" type="button">' + gt('OK') + '</button><br/>');
        var placeholder = $('<span></span><br/>');
        //#. 'Keep me logged into guard' is followed by dropdown box specifying number of minutes or indefinite, %s product name
        var remembertext = $('<label class="checkbox custom small" for="rememberpass">' + gt('Keep me logged into %s', ox.guard.getName()) + '</label>');
        var checkbox = $('<input type="checkbox" id="rememberpass" name="rememberpass' + id + '" value="true" style="margin-top:3px;"/>');
        var rememberpass = $('<div>').append(remembertext.append(checkbox));
        var duration = $('<select id="duration' + id + '" class="og_duration"><option value="10">' + gt('10 minutes') + '</option>' +
                '<option value="20">' + gt('20 minutes') + '</option>' +
                '<option value="30">' + gt('30 minutes') + '</option>' +
                '<option value="60">' + gt('1 hour') + '</option>' +
                '<option value="120">' + gt('2 hours') + '</option>' +
                '<option value="99999">' + gt('Session') + '</option>' +
                '</select>')
                .on('change', function () {
                    $('input[name="rememberpass' + id + '"]').prop('checked', true);
                });
        if (guardSettings.get('defRemember')) {
            duration.val(guardSettings.get('defRemember') === '0' ? 99999 : guardSettings.get('defRemember'));
            if (guardSettings.get('defRemember') !== '0') checkbox.prop('checked', true);
        }
        //#.  Duration is length of time password remembered
        var durationLabel = $('<label>').append(gt('Duration:' + ' '));
        rememberpass.append(durationLabel.append(duration));

        var forgotDiv = $('<div class="og_forgot" style="display:none">');

        if (ox.guard.get('recoveryAvail')) {  // Display password help if available
            var forgotLink = $('<a href="#">').append(gt('Forgot Password'));
            forgotLink.click(function (e) {
                e.preventDefault();
                var options = { id: 'oxguard' };
                ox.launch('io.ox/settings/main', options).done(function () {
                    this.setSettingsPane(options);
                });
            });
            forgotDiv.append(forgotLink);
        }

        var cont = $('<br/><div class="oxguard_error" id = "error' + id + '" style="display:none;"></div>');

        passButton.click(function () {
            go();
        });

        grdPasswordPrompt.append(noSaveWorkAround)
            .append(mainpassprompt.append(passwordbox).append(passButton))
            .append(placeholder)
            .append(rememberpass)
            .append(forgotDiv)
            .append(cont);

        grdPasswordPrompt.keydown(function (e) {
            if (e.which === 13) {
                go();
            }
        });

        window.setTimeout(function () {
            passwordbox.removeAttr('readonly');
        }, 500);

        var contdiv = $('<div class="content" id = "content' + id + '"/>').append(grdPasswordPrompt);

        function go() {
            var password = passwordBoxView.getValue();
            if (password === undefined) return;
            var duration = -1;
            if ($('input[name="rememberpass' + id + '"]').is(':checked')) {
                duration = $('#duration' + id).val();
            }
            if (localOnly) {
                goFunction(password, duration);
                return;
            }
            passwordbox.parent().busy();
            passButton.prop('disabled', true);
            oxguard.savePassword(password, duration, getType(baton))
            .done(function () {
                goFunction(password);
            })
            .fail(function (data) {
                $('#busygif').hide();
                passwordbox.parent().idle();
                passButton.prop('disabled', false);
                require(['io.ox/core/notifications'], function (notifications) {
                    if (data.error && data.code === 'GRD-MW-0005') {
                        notifications.yell('error', gt('Temporary Lockout'));
                    } else if (data.error && data.code === 'GRD-MW-0003') {
                        notifications.yell('error', gt('Bad password'));
                        if (ox.guard.get('recoveryAvail')) $('.og_forgot').show();
                    } else {
                        notifications.yell('error', data.error);
                    }
                });
            });
        }
        return (contdiv);
    }

    return {
        passwordPrompt: passwordPrompt,
        getId: getId
    };
});
