/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/core/tempPassword', [
    'io.ox/core/tk/dialogs',
    'oxguard/core/og_http',
    'oxguard/api/auth',
    'oxguard/core/passwordView',
    'oxguard/api/login',
    'settings!io.ox/mail',
    'gettext!oxguard'
], function (dialogs, http, authAPI, PasswordView, loginAPI, mailSettings, gt) {

    'use strict';

    var firstprompt = false;

    // Prompt for initial password change
    function createOxGuardPasswordPrompt(baton, go, errors, oldpass, index, priorData) {
        if (firstprompt) firstprompt.close();  // If we have previous temp password open, close it, as selection has changed
        var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter: 'okpass' });
        firstprompt = dialog;
        var isnew = ox.guard.get('new');
        var hasPin = ox.guard.get('pin');
        var explain = '';
        if (isnew) {
            //#. %s product name
            dialog.header($('<h4>').text(gt('First %s Security Use', ox.guard.getName())));
            explain = $('<div>');
            explain.append($('<p>').append(gt('You have been sent an email using %s to secure the contents', ox.guard.getName())));
            explain.append($('<p>').append(gt('Please select a new password for use with %s.  This password will be used to open encrypted emails and files that may be sent to you.', ox.guard.getName())));
        } else {
            //#. %s product name
            dialog.header($('<h4>').text(gt('First %s Security Use', ox.guard.getName())));
            explain = $('<div><p>' + gt('Please change the initial temporary %s security password that was sent to you in a separate email.', ox.guard.getName()) + '</p></div>');
        }

        var passdiv = $('<div>').addClass('row-fluid');
        var newogpassword = new PasswordView.view({ 'id': 'newogpassword', 'class': 'password_prompt', 'validate': true });
        var td1 = $('<td>').append(newogpassword.getProtected());
        var newogpassword2 = new PasswordView.view({ 'id': 'newogpassword2', 'class': 'password_prompt' });
        var td2 = $('<td>').append(newogpassword2.getProtected());
        var hint = $('<td>');
        var table = $('<table class="og_password_prompt"/>');
        if (!isnew) {
            var oldPassword = new PasswordView.view({ 'id': 'oldogpassword', 'class': 'password_prompt', 'validate': false });
            table
            .append($('<tr>')
                .append($('<td class="pw">').append($('<label for="oldogpassword">').append(gt('Initial Password'))))
                .append($('<td>').append(oldPassword.getProtected())));
        }
        table
        .append($('<tr><td class="pw"><label for="newogpassword">' + gt('New Password') + ':</label></td></tr>').append(td1).append(hint))
        //#. Confirm new password
        .append($('<tr><td class="pw"><label for="newogpassword2">' + gt('Confirm New') + ':</label></td></tr>').append(td2).append('<td></td>'));
        passdiv.append(table);
        dialog.getBody().append(explain).append(passdiv);
        require(['oxguard/core/passwords'], function (pass) {
            pass.passwordCheck(newogpassword, hint);
            pass.passwordCompare(newogpassword2, newogpassword, hint);
        });
        if (hasPin) {
            var pinPrompt = $('<p>').append(gt('The sender assigned an additional PIN to the account.  This PIN must be entered before you can use this account.  Please enter it now.  Contact the sender directly if you don\'t yet have a pin.'));
            var pinTable = $('<table class="og_password_prompt">');
            var pinLabel = $('<td class="pw">').append('<label for="pinPrompt">' + gt('PIN') + ':</label>');
            var pinEntry = $('<input id="pinInput" name="pinInput" class="form-control password_prompt">');
            pinEntry.focus(function () {
                dialog.getBody().animate({ scrollTop: $('#pinInput').offset().top });
            });
            dialog.getBody().append('<hr/>').append(pinPrompt).append(pinTable.append($('<tr>').append(pinLabel).append($('<td>').append(pinEntry))));
        }
        if (ox.guard.getSettings().noRecovery !== true) {
            var rule = $('<hr/>');
            var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password.' + '</p>'));

            var table2 = $('<table class="og_password_prompt"/>');
            var email1 = $('<input id="recoveryemail" name="recoveryemail" class="form-control password_prompt"/>');
            var email2 = $('<input id="verifyemail" name="verifyemail" class="form-control password_prompt"/>');
            var hint2 = $('<td>');
            var row = $('<tr>').append($('<td class="pw"><label for="recoveryemail">' + gt('Email:') + '</label></td>')).append($('<td>').append(email1)).append(hint2);
            var row2 = $('<tr>').append($('<td class="pw"><label for="verifyemail">' + gt('Verify:') + '</label></td>')).append($('<td>').append(email2));
            table2.append(row).append(row2);
            email1.focus(function () {
                dialog.getBody().animate({ scrollTop: $('#recoveryemail').offset().top });
            });
            dialog.getBody().append(rule).append(recovery).append(table2);
            require(['oxguard/core/emailverify'], function (verify) {
                verify.setValidate(email1, hint2);
                verify.autoCompare(email1, email2, hint2);
            });
        } else {
            var warning = $('<p class="recoveryWarning">').append($('<b>').append(gt('Warning: This password for encryption cannot be restored or recovered in any way.  If forgotten, all encrypted data will be lost.')));
            dialog.getBody().append($('<hr/>')).append(warning);
        }
        if (errors !== undefined) {
            dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
        }
        dialog
        .addPrimaryButton('okpass', gt('OK'), 'okpass')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('cancel', function () {
            firstprompt = false;
        })
        .on('okpass', function () {
            firstprompt = false;
            var oldpass = $('#oldogpassword').val() === undefined ? '' : $('#oldogpassword').val();
            var pass1 = $('#newogpassword').val();
            var pass2 = $('#newogpassword2').val();
            var pin = hasPin ? $('#pinInput').val() : '';
            var emailaddr = $('input[name="recoveryemail"]').val() === undefined ? '' : $('input[name="recoveryemail"]').val();
            var verify = $('input[name="verifyemail"]').val() === undefined ? '' : $('input[name="verifyemail"]').val();
            if (emailaddr !== verify) {
                $('input[name="verifyemail"]').css('background-color', 'salmon');
                createOxGuardPasswordPrompt(baton, go, gt('Emails not equal'), oldpass);
                return;
            }
            if (pass1 !== pass2) {
                $('input[name="newogpassword2"]').css('background-color', 'salmon');
                createOxGuardPasswordPrompt(baton, go, gt('Passwords not equal'), oldpass);
                return;
            }
            var defaultSendAddress = $.trim(mailSettings.get('defaultSendAddress', ''));

            var userdata = {
                newpass: pass1,
                oldpass: oldpass,
                email: emailaddr,
                userEmail: defaultSendAddress ? defaultSendAddress : ox.user,
                user_id: ox.user_id,
                sessionID: ox.session,
                cid: ox.context_id,
                pin: pin
            };
            if ((emailaddr.length > 1) && (!validateEmail(emailaddr))) {
                createOxGuardPasswordPrompt(baton, go, gt('Enter new secondary Email address'), oldpass);
                return;
            }
            if (validateEmail(emailaddr)) userdata.email = emailaddr;
            require(['io.ox/core/notifications'], function (notifications) {
                loginAPI.changePassword(userdata)
                .done(function (resp) {
                    if (typeof data === 'string') resp = $.parseJSON(resp);
                    var data = resp.data ? resp.data : resp;
                    if (data.auth === undefined) {
                        if (data.error) {
                            createOxGuardPasswordPrompt(baton, go, data.error, oldpass, index, userdata);
                        } else {
                            require(['oxguard/core/errorHandler'], function (err) {
                                err.showError(data);
                            });
                        }
                        return;
                    }
                    if (data.auth.length > 20) {
                        $('#grdsettingerror').text(gt('Success'));
                        $('input[name="newogpassword"]').val('');
                        $('input[name="newogpassword2"]').val('');
                        ox.guard.clearAuth();
                        ox.guard.set('recoveryAvail', !ox.guard.getSettings().noRecovery);
                        authAPI.setToken(data.auth).then(function () {
                            if (go) go(baton, pass1, index);
                        });
                        notifications.yell('success', gt('Password changed successfully'));
                        ox.guard.set('pin', false);
                        updateSecondary();
                        ox.guard.set('new', false);
                        // Complete, now offer tour
                        require(['io.ox/core/capabilities', 'oxguard/core/createKeys'], function (capabilities, keys) {
                            if (capabilities.has('guard-mail') && !capabilities.has('guest')) { // only run tour if has guard-mail
                                keys.createKeysWizard();
                            }
                        });

                    } else {
                        if (data.auth === 'Bad new password') {
                            notifications.yell('error', gt('New password must be at least %s characters long', data.minlength));
                            return;
                        }
                        if (data.auth === 'Bad password') {
                            //#. Bad, incorrect password
                            notifications.yell('error', gt('Bad password'));
                            return;
                        }
                        if (data.auth === 'Key not found') {
                            notifications.yell('error', gt('Encryption key not found'));
                            return;
                        }
                        notifications.yell('error', gt('Failed to change password'));
                    }
                })
                .fail(function (data) {
                    if (data.error) {
                        createOxGuardPasswordPrompt(baton, go, data.error, oldpass, index, userdata);
                    } else {
                        notifications.yell('error', gt('Failed to change password'));
                    }
                });
            });
        })
        .show(function () {
            if (priorData) {  // If error dialog, and reloaded, bring back old data
                $('#newogpassword').val(priorData.newpass);
                $('#newogpassword2').val(priorData.newpass);
                $('input[name="recoveryemail"]').val(priorData.email);
                $('input[name="verifyemail"]').val(priorData.email);
            }
            if (oldpass !== undefined) {
                $('#oldogpassword').val(oldpass);
                if (!_.device('ios')) {
                    $('#newogpassword').focus();
                }
            } else
            if (!_.device('ios')) {
                $('#oldogpassword').focus();
            }
            if (errors) {
                if ($('#recoveryemail').length > 0) {
                    dialog.getBody().animate({ scrollTop: $('#recoveryemail').offset().top });
                } else {
                    dialog.getBody().animate({ scrollTop: $('.recoveryWarning').offset().top });
                }

            }
            window.setTimeout(function () {
                var j = 0;
                $('.pw').each(function (i, v) {
                    var w = $(v).width();
                    if (w > j) j = w;
                });
                $('.pw').each(function (i, v) {
                    $(v).width(j);
                });
                var email = $('input[name="recoveryemail"]'); // Watch email entry for valid
                email.on('keyup', function () {
                    if (validateEmail(email.val())) {
                        email.css('background-color', 'white');
                    } else {
                        email.css('background-color', 'rgb(253, 187, 179)');
                    }
                });
            }, 0);
        });
    }

    // Valide legit email address
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    function updateSecondary() {
        if ($('#currentsecondary').length > 0) {
            require(['oxguard/settings/pane'], function (settingsPage) {
                settingsPage.updateEmail();
            });
        }
    }

    return {
        createOxGuardPasswordPrompt: createOxGuardPasswordPrompt
    };

});
