/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

define('oxguard/contacts/register_contacts', [
    'io.ox/core/extensions',
    'oxguard/pgp/keyDetails',
    'settings!oxguard',
    'gettext!oxguard',
    'less!oxguard/style',
    'less!oxguard/contacts/style'
], function (ext, pubkeys, settings, gt) {

    'use strict';

    ext.point('io.ox/contacts/detail/content').extend({
        id: 'pgppublic',
        index: 'last',
        draw: function (baton) {
            // FIXME: this completely disables the point for apps other than settings and contacts (like mail called from sidepanel)
            if (!(baton.app && baton.app.cid)) return;
            // advanced view only
            if (!settings.get('advanced')) return;
            // not listing for distribution lists
            if (baton.data && baton.data.distribution_list) return;

            var cid = baton.app.cid, data = baton.data;

            this.append(
                $('<section class="block" data-block="guard">').attr('id', 'contactKeys' + cid).append(
                    $('<dl class="dl-horizontal">').append(
                        $('<dt>').text(gt('PGP Keys')),
                        $('<dd>').append(
                            // only keys ids are listed - all other elements are hidden (css)
                            pubkeys.listPublic({
                                header: false,
                                id: cid,
                                folder_id: data.folder_id,
                                contact_id: data.id
                            })
                        )
                    )
                )
            );
        }
    });
});
