/*
 *
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Frank Paczynski <frank.paczynski@open-xchange.com>
 */

define('oxguard/api/login', [
    'io.ox/core/http',
    'io.ox/core/event',
    'oxguard/api/util'
], function (http, Events, util) {

    'use strict';

    // https://documentation.open-xchange.com/components/guard/2.10.3/#tag/login

    var encryptPasswords = util.encryptPasswords;

    var api = {

        // Performs a login to obtain an authentication token and various user specific settings.
        login: function (data, keyid, type) {
            return http.POST({
                module: 'oxguard/login',
                params: {
                    action: 'login',
                    keyid: keyid,
                    time: new Date().getTime(),
                    type: type
                },
                contentType: 'application/json; charset=utf-8;',
                processResponse: false,
                data: JSON.stringify(encryptPasswords(data))
            }).then(function (data) {
                if (data.error) return $.Deferred().reject(data.error);
                return data;
            }).fail(util.showError);
        },

        // Performs a login to obtain an authentication token and various user specific settings.
        changePassword: function (data, type) {
            return http.POST({
                module: 'oxguard/login',
                params: {
                    action: 'changepass',
                    type: type
                },
                contentType: 'application/json; charset=utf-8;',
                processResponse: false,
                data: JSON.stringify(data)
            }).fail(util.showError);
        }
    };

    Events.extend(api);

    return api;
});
