/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.servlets.pgpmail;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.common.session.GuardUserSession;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.inputvalidation.RangeInputValidator;
import com.openexchange.guard.keymanagement.commons.GuardKeys;
import com.openexchange.guard.keymanagement.services.GuardKeyService;
import com.openexchange.guard.mime.services.MimeParser;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.fileupload.FileUploadHandler;
import com.openexchange.pgp.mail.PGPMimeService;
import com.openexchange.server.ServiceLookup;

/**
 * {@link EncryptAction} Action to encrypt an incoming email
 *
 * @deprecated As of 2.10.7. Use {@link com.openexchange.guard.servlets.crypto.MimeEmailAction}
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.4
 */
@Deprecated
public class EncryptAction extends GuardServletAction {

    private static final Logger Log = org.slf4j.LoggerFactory.getLogger(EncryptAction.class);
    private static GuardKeyService keyservice;
    private static PGPMimeService pgpMimeService;
    private static GuardConfigurationService guardConfigService;
    private static final String MESSAGE_FIELD_NAME = "file";

    public EncryptAction(ServiceLookup services) throws OXException {
        keyservice = services.getServiceSafe(GuardKeyService.class);
        guardConfigService = services.getServiceSafe(GuardConfigurationService.class);
        pgpMimeService = services.getServiceSafe(PGPMimeService.class);
    }

    @Override
    protected void doActionInternal(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession) throws Exception {
        RangeInputValidator<Integer> positiveValidator = new RangeInputValidator<Integer>(0, Integer.MAX_VALUE);

        final int userId = positiveValidator.assertInput(ServletUtils.getIntParameter(request, "user", true), "user");
        final int contextId = positiveValidator.assertInput(ServletUtils.getIntParameter(request, "context", true), "context");
        Log.debug("encrypting mime messsage");
        GuardKeys keys = keyservice.getKeys(userId, contextId);
        if (keys == null) {
            Log.debug("No keys found for encrypting email through encrypt_mime");
            throw OXException.general("No Keys");
        }
        FileUploadHandler fileUploadHandler = new FileUploadHandler(guardConfigService, true);
        Collection<FileItem> items = fileUploadHandler.parseItems(request);
        try (InputStream messageStream = fileUploadHandler.getFileItemStreamFrom(items, MESSAGE_FIELD_NAME, true);) {
            MimeParser mimeParser = new MimeParser(messageStream);
            if (mimeParser.isPGPMime() || mimeParser.isPGPInline()) {
                Log.debug("Guard encrypt_mime exiting, already encrypted");
                throw OXException.general("Already encrypted");
            }
            MimeMessage encrypted = pgpMimeService.encrypt(mimeParser.getMessage(), Arrays.asList(keys.getPGPPublicKey()));
            encrypted.writeTo(response.getOutputStream());

        } catch (Exception e) {
            Log.error("Error encrypting incomgin email message", e);
            throw OXException.general("Error enrypting incoming message");
        }

    }
}
