/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

import com.j256.simplemagic.endian.EndianType;
import com.j256.simplemagic.types.BaseLongType;
import com.j256.simplemagic.types.LongType;

public class ShortType
extends BaseLongType {
    private static final int BYTES_PER_SHORT = 2;

    public ShortType(EndianType endianType) {
        super(endianType);
    }

    @Override
    public int getBytesPerType() {
        return 2;
    }

    @Override
    public long maskValue(long value) {
        return value & 0xFFFFL;
    }

    @Override
    public int compare(boolean unsignedType, Number extractedValue, Number testValue) {
        short testShort;
        if (unsignedType) {
            return LongType.staticCompare(extractedValue, testValue);
        }
        short extractedShort = extractedValue.shortValue();
        if (extractedShort > (testShort = testValue.shortValue())) {
            return 1;
        }
        if (extractedShort < testShort) {
            return -1;
        }
        return 0;
    }
}

