/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.servlets.pgpcore;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.configuration.GuardConfigurationService;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.pgpcore.services.PGPSigningService;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.GuardUserSession;
import com.openexchange.guard.servlets.fileupload.FileUploadHandler;
import com.openexchange.pgp.core.PGPSignatureVerificationResult;

/**
 * {@link VerifyAction}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.2
 */
public class VerifyAction extends GuardServletAction {

    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String JSON_DATA_FIELD_NAME = "json";
    private static final String DATA_FIELD_NAME = "data";
    private static final String SIGNATURE_FIELD_NAME = "signature";

    /*
     * (non-Javadoc)
     *
     * @see com.openexchange.guard.servlets.GuardServletAction#doActionInternal(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, com.openexchange.guard.servlets.authentication.GuardUserSession)
     */
    @Override
    protected void doActionInternal(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession) throws Exception {

        FileUploadHandler fileUploadHandler = new FileUploadHandler(Services.getService(GuardConfigurationService.class));
        Collection<FileItem> items = fileUploadHandler.parseItems(request);
        try (InputStream dataStream = fileUploadHandler.getFileItemStreamFrom(items, DATA_FIELD_NAME,true);
            InputStream signatureStream = fileUploadHandler.getFileItemStreamFrom(items, SIGNATURE_FIELD_NAME,true)){

            PGPSigningService signingService = Services.getService(PGPSigningService.class);
            response.setContentType(CONTENT_TYPE_JSON);
            List<PGPSignatureVerificationResult> verifyResults = signingService.verify(dataStream, signatureStream);
            ServletUtils.sendJsonOK(response, VerifyResultJsonFactory.toJson(verifyResults));
        }
    }
}
