/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.JsonObject;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.common.util.JsonUtil;
import com.openexchange.guard.handler.ResponseHandler;
import com.openexchange.guard.inputvalidation.EmailValidator;
import com.openexchange.guard.keymanagement.services.PasswordChangeService;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.oxapi.Api;
import com.openexchange.guard.oxapi.OxCookie;
import com.openexchange.guard.servlets.authentication.GuardUserSession;

/**
 * {@link ChangePasswordHandler}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public class ChangePasswordHandler {

    private static Logger LOG = LoggerFactory.getLogger(ChangePasswordHandler.class);

    /**
     * Change password
     *
     * @param request
     * @param response
     * @param cookie
     * @return
     * @throws OXException
     * @throws Exception
     */
    public void changepass(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession, OxCookie cookie) throws OXException {
        JsonObject json = Services.getService(ResponseHandler.class).getJsonAndDecodeEncryptedPasswords(request, userSession.getUserId(), userSession.getContextId());
            // if ox member, verify actually logged in to ui
            if (userSession.getGuardContextId() > 0) {
                Api ap = new Api(cookie, request);
                if (ap.verifyLogin() == false) {
                    response.setStatus(550);
                    return;
                }
            }
            String newpass = JsonUtil.getStringFromJson(json, "newpass", true);
            String question = "";
            if (json.has("question")) {// Sent with new question and answer?
                question = json.get("question").getAsString();
            }
            String answer = "";
            if (json.has("answer")) {
                answer = json.get("answer").getAsString();
            }
            if (json.has("email")) {
                if (!json.get("email").getAsString().equals("")) {
                    answer = new EmailValidator().assertInput(json.get("email").getAsString(), "email");
                }
                if (!answer.equals("")) {
                    question = "e";
                }
            }
            String userEmail = "";
            if (json.has("userEmail")) {
                userEmail = json.get("userEmail").getAsString();
            }
            String oldpass = "";
            String pin = "";
            if (json.has("pin")) {
                pin = json.get("pin").getAsString();
            }
            oldpass = JsonUtil.getStringFromJson(json, "oldpass", true);
            PasswordChangeService passService = Services.getService(PasswordChangeService.class);
            String result = passService.changePassword(userSession.getUserId(),
                userSession.getContextId(),
                userEmail,
                oldpass,
                newpass,
                question,
                answer,
                pin,
                userSession.getGuardSession());
            ServletUtils.sendOK(response, "applicaton/json", result);

    }

}
