/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.sharing;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONArray;
import com.openexchange.exception.OXException;
import com.openexchange.guard.user.UserIdentity;

/**
 * {@link SharingService}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public interface SharingService {

    /**
     * Method to change the PGP encrypted sessions to allow sharing of a file with multiple recipients
     * @param origData  InputStream of the original file
     * @param List of recipients userIds that should share the file.
     * @param userIdentity Guard UserIdentity of the owner
     * @param out Output stream for the changed file
     * @throws OXException
     */
    public void shareFile(InputStream origData, List<Integer> userIds, UserIdentity userIdentity, OutputStream out) throws OXException;

    /**
     * Add to the list of recipients required shares
     * Recipients are in cid/id structure, shares are per email
     * Looks up Guard cid/id (may be guest) and appends them to list of recipients
     * @param recipients
     * @param emails
     * @return
     * @throws OXException
     */
    public List<String> getAdditionalShareRecipients (List<String> recipients, List<String> emails) throws OXException;
}
