/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.internal;


/**
 * {@link MilterConstants}
 *
 * Constants taken from http://cpansearch.perl.org/src/AVAR/Sendmail-PMilter-0.98/doc/milter-protocol.txt
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class MilterConstants {

    public static final int COMMAND_CONNECT = 'C';
    public static final int COMMAND_MACRO = 'D';
    public static final int COMMAND_HELO = 'H';
    public static final int COMMAND_MAIL = 'M';
    public static final int COMMAND_RCPT = 'R';
    public static final int COMMAND_BODYEOB = 'E';
    public static final int COMMAND_HEADER = 'L';
    public static final int COMMAND_EOH = 'N';
    public static final int COMMAND_OPTNEG = 'O';
    public static final int COMMAND_QUIT = 'Q';
    public static final int COMMAND_BODY = 'B';
    public static final int COMMAND_ABORT = 'A';

    public static final int RESPONSE_ACCEPT = 'a';
    public static final int RESPONSE_ADDHEADER = 'h';
    public static final int RESPONSE_ADDRCPT = '+';
    public static final int RESPONSE_CHGHEADER = 'm';
    public static final int RESPONSE_CONTINUE = 'c';
    public static final int RESPONSE_DELRCPT = '-';
    public static final int RESPONSE_DISCARD = 'd';
    public static final int RESPONSE_QUARENTINE = 'q';
    public static final int RESPONSE_PROGRESS = 'p';
    public static final int RESPONSE_REJECT = 'r';
    public static final int RESPONSE_REPLBODY = 'b';
    public static final int RESPONSE_REPLYCODE = 'y';
    public static final int RESPONSE_TEMPFAIL = 't';

    public static final int PROCESS_NOCOMMAND = 0x0001;
    public static final int PROCESS_NOHELO = 0x0002;
    public static final int PROCESS_NOMAIL = 0x0004;
    public static final int PROCESS_NORCPT = 0x0008;
    public static final int PROCESS_NOBODY = 0x0010;
    public static final int PROCESS_NOHDRS = 0x0020;
    public static final int PROCESS_NOEOH = 0x0040;

    public static final int SMFIA_INET = '4';
    public static final int SMFIA_INET6 = '6';

}
