/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.milter.actions.encryptor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import com.openexchange.guard.milter.actions.MilterEOBAction;
import com.openexchange.guard.milter.service.MilterMail;
import com.openexchange.guard.milter.service.impl.ActionResponse;

/**
 * {@link MilterEOBActionEncryptor}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.8.0
 */
public class MilterEOBActionEncryptor implements MilterEOBAction {

    static Logger Log = org.slf4j.LoggerFactory.getLogger(MilterEOBActionEncryptor.class);

    private byte[] encrypted = null;
    String contentType = null;

    @Override
    public boolean handleMessageBody(MilterMail mail) {

        DoEncrypt encryptor = new DoEncrypt();
        try {
            Log.debug("Milter encrypting incoming email");
            encrypted = encryptor.encrypt(mail);
            contentType = encryptor.getContentType();
            if (encrypted != null) return true;
        } catch (Exception e) {
            Log.error("Problem encrypting email ", e);
            return false;
        }
        return false;
    }

    /* (non-Javadoc)
     * @see com.openexchange.guard.milter.actions.MilterEOBAction#sendResponses(java.nio.channels.WritableByteChannel)
     */
    @Override
    public boolean sendResponses(WritableByteChannel channel) throws IOException {
        ActionResponse resp = new ActionResponse();
        resp.changeHeader("Content-Type", contentType);
        resp.sendResponse(channel);
        resp.reset();
        resp.addHeader("X-AutoEncrypted", "true");
        resp.sendResponse(channel);
        resp.reset();
        resp.replBody(ByteBuffer.wrap(encrypted));
        resp.sendResponse(channel);
        return true;
    }

}
