/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.keymanagement.services;

import java.util.List;
import com.openexchange.exception.OXException;
import com.openexchange.guard.keymanagement.commons.OGPGPKeyRing;

/**
 * The {@link ContactKeyService} serves public PGP keys for OX contacts.
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public interface ContactKeyService {

    /**
     * Retrieves public PGP keys (as instances of {@link OGPGPKeyRing}) for a given OX contact.
     *
     * @param userId The user's ID.
     * @param contextId The user's context ID.
     * @param contact_id The ID of the contact to get the PGP keys for.
     * @param folder_id The folder ID of the contact to get the PGP keys for.
     * @return A list of {@link OGPGPKeyRing} instances for the given contact.
     * @throws OXException
     */
    List<OGPGPKeyRing> getKeysForContact(int userId, int contextId, String contact_id, String folder_id) throws OXException;
}
