/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.database.update.shardUpdate.updates;

import com.openexchange.exception.OXException;
import com.openexchange.guard.database.internal.GuardShardingIDManagement;
import com.openexchange.guard.database.update.shardUpdate.ShardUpdateTask;

/**
 * {@link AutoIncrement}
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v7.10.3
 */
public class AutoIncrement extends ShardUpdateTask {

    GuardShardingIDManagement shardIdManagement;

    public AutoIncrement (GuardShardingIDManagement shardIdManagement) {
        this.name = "Check Auto Increment";
        this.shardIdManagement = shardIdManagement;
    }

    @Override
    public boolean doUpdate(int shardId) throws OXException {
        try {
            shardIdManagement.updateAutoIncrement(shardId);
        } catch (OXException ex) {
            LOG.error("Error executing AutoIncrment check for shard " + shardId, ex);
            return false;
        }
        return true;
    }

}
