﻿/// <reference path="jquery-1.7.1.js" />
/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

var userid;
var username;
var cid;
var sessionID;
var auth;
var itemid;
var templid;
var logindata;
var settings;
var attachlist = [];
var uploadlist = [];
var savedata;
var lastMod;
var noRecovery = false;

try {// Load root from config file.  Error if missing or unable to determine api address
    var root = getRoot();
} catch (e) {
    alert('missing or corrupt config.js file');
}


var language = getURLParameter('lang') ? getURLParameter('lang').replace(/\./g,'') : 'en-US';
templid = parseInt(getURLParameter("templid"));
if (templid == null || isNaN(parseInt(templid))) {   // If no clean template ID, see if we have a default from config.js
    try {
        if (typeof(getDefaultTemplateId) == 'function') {
            templid = getDefaultTemplateId ();
            if (templid == 0) templid = null;
        }
    } catch (e)
    {
        log('missing default ID from config file');
    }
}
if (templid !== null) {
    $('head').append('<link rel="stylesheet" type="text/css" href="./templates/' + templid + '-style.css">');
}

$().ready(function () {// Once ready, load templates.
    // Add addditional templates here.  Specify template id, the template file, and the location
    log ('template id is ', templid);
    // Template for css.  Format cid-style.css
    if (templid !== null) {
        if (!isNaN(parseInt(templid))) {// Check cid is actually int, and if so, load templates styles
            getTemplate(templid, "header.html", "top-bar-placeholder");
            getTemplate(templid, "footer.html", "footer-placeholder");
        }
    }
    $('#top-bar-placeholder').show();
    $('#footer-placeholder').show();

    itemid = getURLParameter("email");
    var option= {
            resGetPath: 'l10n/__ns__-__lng__.json',
            debug: debug,
            detectLngQS: 'lang',
            fallbackLng: 'en_US',
            customLoad: loadTranslations

    };
    i18n.init(option, function(t) {
        $('.view').i18n();
        if (root !== undefined) view('login');
        if (itemid === null) {
            $('#loginHeader').text(i18n.t('Please provide your credentials'));
        }
    })
    .done(function () {
        $.get('./l10n/languages', function (languages) {
            var selectedLanguage = getURLParameter('lang');
            if (selectedLanguage === null) {
                selectedLanguage = "en_US";
            }
            $.each(languages, function (c, n) {
                if (c === selectedLanguage) {
                    $('#languageSelect').append('<li class="active"><a href="#" language="' + c + '">' + n + '</a></li>');
                    $('#languageSelectButton').html(n + ' <span class="caret"></span>');
                } else {
                    $('#languageSelect').append('<li><a href="#" language="' + c + '">' + n + '</a></li>');
                }
            });

            var user = getURLParameter('user');
            if (user !== null) {
                $('#Username').val(user);
                $('#Username').hide();
                $('#loginHeader').text(i18n.t('Please provide your encryption password'));
                $('#Password').focus();
            }
            var newGuest = templid = getURLParameter('newGuest');
            if (newGuest) {
                login();
            }
        }, 'json');

        // Language selection listener
        $("#languageSelect").click(loadLanguage);
        var resetid = getURLParameter('resetid');
        if (resetid != null) {
            view('DoResetDiv');
        }

    });
});

function loadLanguage (ev) {
    var url = document.URL;
    if (url.indexOf('&lang=') > 0) {
        url = url.substring (0, url.indexOf('&lang='));
    }
    url = url + (url.indexOf('?') > 0 ? '': '?') + '&lang=' + $(ev.target).attr('language');
    window.location.replace(url);
}

// Load translation for language.  Custom overwrites.
function fetchTranslations (callback, options) {
    var requests = [];
    var custom, translation = {};
    $.get("l10n/translation-" + language + ".json")
        .done(function(data) {
                $.get("l10n/custom-" + language + ".json")
                .done(function(custdata) {
                    $.extend(data, custdata);
                })
                .always(function () {
                    callback(data);
                });
        })
        .fail(function () {
            console.log('Failed to load language ' + language);
            $.get("l10n/translation-" + options.fallbackLng + ".json")
                .done(function (data) {
                    callback(data);
                })
                .fail(function (e) {
                    console.log(e);
                    alert('Failed to default language');
                });
        });
}

function loadTranslations (lng, ns, options, loadComplete) {
    fetchTranslations (function (data) {
        loadComplete(null, data);
    }, options);
}

// Load the template.  Format should be cid-template .  Location in template subdirectory
function getTemplate (templid, template, locationID) {
    $.get('./templates/' + (templid === null ? "" : (templid + "-")) + template, function (data) {
        $('#' + locationID).replaceWith(data);
    })
    .fail(function () {// If not found with cid, try loading default
        $.get('./templates/' + template, function (data) {
            $('#' + locationID).replaceWith(data);
        });
    });
}


// Provides login to oxguard backend.  Authentication key is returned and stored
function login() {
    username = $('#Username').val();
    var password = $('#Password').val();
    if(typeof String.prototype.trim === 'function') {// Trim not supported in IE
        password = $('#Password').val().trim();
    }
    $('#authorizing').show();
    logindata = {
            username : username,
            password : password
    }
    var url = 'oxguard/login?action=guest';
    // If this is a getkey login, then we need a different auth
    var action = getURLParameter('action');
    if (action === 'getkey') {
        logindata.salt = getURLParameter('token');
        logindata.userid = getURLParameter('userid');
        logindata.cid = getURLParameter('cid');
        url = 'oxguard/retrieve?action=login';
    }
    $.ajax({
        url: root + url,
        type:'POST',
        data: JSON.stringify(logindata),
        contentType:'application/json; charset=utf-8',
        success: function (data) {
            log('loging data: ', data);
            if (data === null) {
                alert('error');
                return;
            }
            if (data.productName) {
                $('head').append('<title>' + data.productName + '</title>');
            }
            if (data.auth === 'Password Needed') {
                $('#login').hide();
                $('#NewPassword').show();
                userid = data.userid;
                cid = data.cid;
                sessionID = data.sessionID;
                auth = data.auth;
                return;
            }
            if (data.auth === 'Bad Password' || data.auth === 'No Key') {
                if (password === '') {
                    $('#authorizing').hide();
                    return;  // This was a blank login attempt
                }
                //#. Bad username or Password at login
                $('#ErrorBox').html(i18n.t('Bad username / Password'));
                $('#ErrorBox').show();
                $('#Username').show();
                $('#Password').val('').focus();
                $('#authorizing').hide();
                /*
                if (data.recoveryAvail === false) {
                    $('.forgot').hide();
                } else {
                    $('.forgot').show();
                }
                */
                return;
            }

            if (data.auth === 'lockout') {
                $('#ErrorBox').html(i18n.t('Account locked out try later'));
                $('#ErrorBox').show();
                $('#Username').hide();
                $('#Password').hide();
                $('#LoginButton').hide();
                $('#authorizing').hide();
                /*
                if (data.recoveryAvail === false) {
                    $('.forgot').hide();
                }
                */
                return;
            }
            if (data.auth === 'not found') {
                $('#ErrorBox').html(i18n.t('Account not found'));
                $('#ErrorBox').show();
                $('#authorizing').hide();
                return;
            }
            if (data.auth === 'new') {
                view('newUser');
                $('#welcome').text(i18n.t('Welcome to $s').replace('$s', data.productName));
                if (data.pin) {
                    $('#pinDiv').show();
                }
                settings = data.settings;
                if (data.settings && data.settings.noRecovery) {
                    $('#newQA').hide();
                }
                return;
            }
            noRecovery = data.settings.noRecovery;
            lastMod = data.lastMod;
            if (data.auth.length > 20) {
                okLogin(data, action);
                return;
            }
            if (data.auth === 'PIN') {
                $('#authorizing').hide();
                $('#pin').show();
                $('#pinbox').focus();
                return;
            }
        }

    })
    .fail(function (data) {
        $('#authorizing').hide();
        alert('fail');
    });
}

function okLogin(data, action) {
    userid = data.userid;
    cid = data.cid;
    sessionID = data.sessionID;
    auth = data.auth;
    if (action === 'getkey') {
        rKeys(data);
        return;
    }
    settings = data.settings;
    itemid = getURLParameter("email");
    if (itemid === null) {
        $('.back').remove(); // remove back button if PGPManage only option
        view('pgpManage');
    } else {
        if (data.redirect) {
            redirect(data);
        } else {
            convertGuest(data);
        }
    }
    logindata = null;
}

function redirect (data) {
    // Let's do a safety check to see if redirect in the same company
    var baseUrl = window.location.protocol + "//" + window.location.host;
    if (data.redirect.indexOf(baseUrl) === 0 || data.redirect.indexOf(root) === 0) {
        window.location = data.redirect;
    } else {  // If not, display to the user the redirect URL
        view('redirect');
        $('#redirectURL').text(data.redirect);
        $('#OkRedirect').on('click', function() {
            okRedirect(data.redirect);
        });
    }
}

function okRedirect(url) {
    window.location = url;
}

function convertGuest(data) {
    var language = getURLParameter('lang').replace(/\./g,'');
    $.ajax({
        url: root + "oxguard/guest?action=convertGuest&auth=" + encodeURIComponent(data.auth) +
        '&item=' + itemid + '&lang=' + language,
        type:'POST',
        data: '',
        contentType:'application/json; charset=utf-8',
        success: function (resp) {
            if (resp.error) {
                alert(resp.error);
                $('#authorizing').hide();
            } else {
                redirect(resp.data);
            }
        }
    });
}

function loginPin() {
    logindata.pin = $('#pinbox').val();
    $.ajax({
        url: root + "oxguard/login?action=guest",
        type:'POST',
        data: JSON.stringify(logindata),
        contentType:'application/json; charset=utf-8',
        success: function (data) {
            try {
                log("loging data: ", data);
                if (data.auth.length > 20) {
                    okLogin(data);
                    return;
                }
                if (data.auth === "Bad") {
                    $('#PinErrorBox').html(i18n.t("Bad PIN")).show();
                    $('#pinbox').val('').focus();
                    return;
                }
                if (data.auth === "lockout") {
                    $('#PinErrorBox').html(i18n.t("Account locked out try later")).show();
                    $('#pinbox').val('').hide();
                    $('#PinButton').hide();
                    return;
                }
            } catch (e) {
                $('#PinErrorBox').html(i18n.t("Error checking PIN")).show();
                log(e);
            }
        }
    })
    .fail(function () {
        $('#PinErrorBox').html(i18n.t("Error checking PIN")).show();
        return;
    });
}

function firstPassChange() {
    var newpass = $('#firstpass').val();
    var newpass2 = $('#firstpass2').val();
    if (newpass !== newpass2) {
        $('#firstErrorDiv').text(i18n.t('Passwords not equal'));
        $('#firstErrorDiv').show();
        $('#firstpass').focus();
        return;
    }
    var question = $('#newQuestion').val();
    var answer = $('#newAnswer').val();
    if (settings.noRecovery === false) {
        if (answer.length < 2) {
            $('#firstErrorDiv').text(i18n.t('Answer required for password reset option'));
            $('#firstErrorDiv').show();
            $('#newAnswer').focus();
            return;
        }
    }
    var itemId = getURLParameter("email");
    var pin = $('#newpin').val();
    var passdata = {
            newpass: newpass,
            question: question,
            answer: answer,
            pin: pin,
            email: $('#Username').val(),
            itemId: itemId
        };
    showWait();
        $.ajax({
            url: root + 'oxguard/guest?action=firstpass',
            type:'POST',
            data: JSON.stringify(passdata),
            contentType:'application/json; charset=utf-8',
            success: function (data) {
                $('#firstErrorDiv').hide();
                if (data instanceof Array) data = data[0];
                if (data && data.error) {
                    hideWait();
                    if (data.code === 'GRD-CHANGE-PW-0002') {
                        $('#firstErrorDiv').text(i18n.t('PIN invalid or missing'));
                        $('#firstErrorDiv').show();
                        $('#newpin').focus();
                        return;
                    }
                    if (data.code === 'GRD-CHANGE-PW-0001') {
                        $('#firstErrorDiv').text(i18n.t('Password Length Too Short'));
                        $('#firstErrorDiv').show();
                        $('#firstpass').focus();
                        return;
                    }
                    alert (data.error + ' ' + data.error_desc);
                    return;
                }
                if (data.auth && data.auth.length > 20) {
                    auth = data.auth;
                    okLogin(data);
                }
            }
        })
        .fail(function (data) {
            $('#firstErrorDiv').text(i18n.t('Problem connecting with the server'));
            $('#firstErrorDiv').show();
            alert(data);
        })
        .always(function () {
            hideWait();
        });

}

function showChangepass() {
    if (lastMod === 'null') {
        showChangeFirstPassword();
    } else {
        view('NewPassword');
    }
}

function showWait() {
    $('#waitDiv').show();
}

function hideWait() {
    $('#waitDiv').hide();
}

function comparePass(pass1, pass2, err1, err2) {
    var val1 = $('#' + pass1).val();
    var val2 = $('#' + pass2).val();
    if ((val1 != val2) && (val2 != '')) {
        $('#' + err2).text(i18n.t('Passwords do not match'));
    } else {
        $('#' + err2).text('');
    }
    if (settings.min_password_length && (val1.length < settings.min_password_length)) {
        $('#' + err1).text(i18n.t('Too short'));
    } else {
        $('#' + err1).text('');
    }
}

//Change the oxguard password
function firstChangePass() {
    var pass1 = $('#change1').val();
    if (pass1.length < 8) {
        $('#change1').focus();
        showChangePassError(i18n.t("Password must be at least 8 characters long"));
        return;
    }
    if (pass1 !== $('#change2').val()) {
        $('#change1').focus();
        showChangePassError(i18n.t("Passwords do not match"));
        return;
    }
    var answer = $('#answer').val();
    if (answer.length < 3 && !noRecovery) {
        $('#answer').focus();
        showChangePassError(i18n.t("Please provide an answer for the security question"));
        return;
    }
    var password = $('#Password').val();
    if(typeof String.prototype.trim === 'function') { // Trim not supported in IE
        password = password.trim();
    }
    var userdata = {
        newpass: pass1,
        oldpass: password,
        question: $('#question').val(),
        answer: $('#answer').val(),
        user_id: userid,
        sessionID: sessionID,
        cid: cid
    };
    log("changepass data: ", userdata);
    $.ajax({
        url: root + 'oxguard/guest?action=changepass&session=' + sessionID + '&auth=' + encodeURIComponent(auth),
        type:'POST',
        data: JSON.stringify(userdata),
        contentType:'application/json; charset=utf-8',
        success: function (data) {
            if (typeof data === 'string') data = $.parseJSON(data);
            log('success ', data);
            if (data.auth.length > 20) {
                auth = data.auth;
                lastMod = 'now';
                sessionID = data.sessionID;
                $('#new1').val('');
                $('#new2').val('');
                $('#firstChangeError').html(i18n.t("Password Changed"));
                $('#firstChangeError').removeClass('alert-danger').addClass('alert-success').show();
                window.setTimeout(function () {
                    $('#firstChangeError').html();
                    $('#firstChangeError').hide;
                    $('#firstChangePassDiv').hide();
                },1000);
                $('#Reader').css("position", "inherit");
            }
        }
    })
    .fail(function () {
        showChangePassError(i18n.t("Failed to change password"));
        $('#firstChangeError').removeClass('alert-success').addClass('alert-danger').show();
    });
}


function showChangeFirstPassword () {
    $('#Reader').css("position", "fixed");
    if((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i))) {
        $('.passchange').css('height', '100%').css('width', '100%').css('margin-top', '0%')
        .bind('touchstart', function (e) {
            if (e.target.type !== 'password' && e.target.type !== 'text') {
                document.activeElement.blur();
            }
        });
    }
    $('#firstChangePassDiv').show();
    if (noRecovery) {
        $('.qaDiv').hide();
        $('.passchange').css('height', '50%').css('min-height', '400px');
    }
}

function fail(alerttype)
{
    if (alerttype === undefined) {
        alert(i18n.t("An error occurred"));
    } else {
        alert(alerttype);
    }
    $('#authorizing').hide();
    $('#decoding').hide();
    view('login');
    log('fail');
}


// Get base url
function getURLParameter(name) {
    return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null
}

function cancelprop(e) {
    e.cancelBubble = true;
    e.returnValue = false;
    // non-ie
    e.preventDefault && e.preventDefault();
    e.stopPropagation && e.stopPropagation();
}

function getauth () {
    return(auth);
}

function nochange() {
    $('#firstChangePassDiv').hide();
    $('#Reader').css("position", "inherit");
}

function forgotPass() {
    var email = $('#EmailAddr').val();
    if (email.indexOf("@") >= 1) {
        $('#wait').show();
        var url = root + 'oxguard/guest?action=getquestion&email=' + email;
        $.get(url, function (data) {
            log ('Reset get question ', data);
            if (data.trim() === "nf") {
                $('#EmailAddr').focus();
                $('#ForgotError').html(i18n.t("Please provide valid email address"));
                $('#ForgotError').show();
                $('#wait').hide();
                return;
            }
            if ((data.indexOf("default") > -1) || (data === "")) {
                $('#AskForgotQuestion').text(i18n.t("Favorite Movie"));
            } else {
                $('#AskForgotQuestion').text(data);
            }
            $('#wait').hide();
            if (data.trim() === 'nr') {
                //$('#ForgotError').html(i18n.t("Password reset not available for this account"));
                //$('#ForgotError').show();
                view('Reset');
                return;
            }
            if ((data.trim() === "null") || (data.trim() === "PIN")) {// If no recovery answer yet set up, reset
                forgotPass2()
                $('#wait').show();
            } else {
                view ('ForgotPage2');
            }
        })
        .fail (function () {
            $('#ForgotError').html(i18n.t("Failed to connect to server"));
        $('#ForgotError').show();
        });

    } else {
        $('#EmailAddr').focus();
        $('#ForgotError').html(i18n.t("Please provide valid email address"));
        $('#ForgotError').show();
    }

}

function forgotPass2() {
    var email = $('#EmailAddr').val();
    var answer = $('#forgotAnswer').val();
    $('#ForgotError2').hide();
    $('#wait2').show();
    var url = root + 'oxguard/guest?action=resetpassword&email=' + email + '&answer=' + answer + '&language=' + language + '&templid=' + templid;
    $.get(url, function (data) {
        log("forgot2", data);
        $('#wait2').hide();
        if (data.indexOf('OK') > -1) {
            alert (i18n.t("Password Emailed"));
            view ('login');
        }
        if (data.indexOf('FailNotify') > -1) {
            alert (i18n.t("Failed to change password"));
            view ('login');
        }
        if (data.trim() === 'No Match') {
            $('#ForgotError2').html(i18n.t("Incorrect Answer"));
            $('#ForgotError2').show();
        }
        if (data.trim() === 'lockout') {
            $('#ForgotError2').html(i18n.t("Temporary account lockout"));
            $('#ForgotError2').show();
        }
    })
    .fail (function (data) {
        $('#wait2').hide();
        $('#wait').hide();
        log("Forgot2 fail ", data);
        if (data.responseText.indexOf('no recovery') > 0) {
            $('#ForgotError2').html(i18n.t("Password reset not available for this account"));
        } else {
            $('#ForgotError2').html(i18n.t("Failed to change password"));
        }
        $('#ForgotError2').show();
    });
}

// Function to send account reset request
function resetAccount () {
    view('ResetResultDiv');
    var email = $('#EmailAddr').val();
    var url = root + 'oxguard/guest?action=resetaccount&user=' + email + '&templid=' + templid;
    $.get(url, function (data) {
        if (data instanceof Array) data = data[0];
        log("reset", data);
        if (data && data.error) {
            $('#ResetResult').text(data.error + ' ' + data.error_desc);
        } else {
            if (data.data) {
                $('#ResetResult').html(i18n.t("A verification email has been sent  Please check your inbox and follow the instructions in the email"));
            } else {
                $('#ResetResult').text(i18n.t("Unkown Error"));
            }
        }
    });
}

function doResetAccount() {
    var pass1 = $('#resetnew1').val();
    var pass2 = $('#resetnew2').val();
    if (pass1 != pass2) {
        $('#resetError').text(i18n.t('Passwords not equal'));
        return;
    }
    if (pass1.length < 4) {
        $('#resetError').text(i18n.t('Passwords too short'));
    }
    $('#resetError').text('');
    var resetid = getURLParameter('resetid');
    var email = getURLParameter('user');
    var data = {
            email: email,
            resetid: resetid,
            password: pass1
    }
    var url = root + 'oxguard/guest?action=doresetaccount';
       $.ajax({
            url: url,
            type: "POST",
            data: JSON.stringify(data),
            contentType:'application/json; charset=utf-8',
            processData: false,  // tell jQuery not to process the data
            contentType: false,   // tell jQuery not to set contentType
            success: function(data){
                if (data instanceof Array) data = data[0];
                if (data && data.error) {
                    $('#resetErrorDiv').show();
                    $('#resetErrorBox').text(data.error);
                } else {
                    $('#resetErrorDiv').hide();
                    $('#ResetStep1').hide();
                    $('#ResetStep2').show();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
            }
       });
}

function view (element) {
    $('.view').hide();
    if (element !== undefined)
        $('#' + element).show();

}

function back () {
    view('Reader');
}

// PGP Management

function pgpManage() {
    view('pgpManage');
    updateCheckBox();
}

function downloadPGPPublic () {
        var params = '&id=' + userid + '&cid=' + cid + '&auth=' + encodeURIComponent(auth);
        window.open(root + '/oxguard/pgpmail/public.asc?action=getkeybyid' + params, '_blank');
}

function downloadPGPPrivate () {
    var params = '&id=' + userid + '&cid=' + cid + '&auth=' + encodeURIComponent(auth) + '&guest=true&both=true';
    var link = root + '/oxguard/pgp/private.asc?action=getprivkeybyid' + params;
    window.open(link, '_blank');
}

function updateCheckBox () {
    if (settings.inline) {
        $('#inline').prop('checked', true);
    } else $('#inline').prop('checked', false);
    if (settings.direct) {
        $('#direct').prop('checked', true);
        $('#inlineDiv').show();
    } else {
        $('#direct').prop('checked', false);
        $('#inlineDiv').hide();
    }
}

function showPGPDirect () {
    if ($('#direct').is('::checked') !== true) {
        $('.mask').show();
        $('.pgpDirect').show();
        return false;
    }
}

function setDirect() {
    $('#direct').prop('checked', true);
    updateSettings();
    $('.mask').hide();
    $('.pgpDirect').hide();
}

function updateSettings () {
    var inline = $('#inline').is('::checked');
    var direct = $('#direct').is('::checked');
    var data = {
            inline : inline,
            direct : direct
    };
    settings.inline = inline;
    settings.direct = direct;

    if (!direct) {
        $('#inlineDiv').hide(); // hide inline data if not direct
    } else $('#inlineDiv').show();

    var json = {
            id : userid,
            cid : cid,
            data : data
    };
    $.ajax({
        url: root + '/oxguard/settings?action=set&session=' + sessionID + '&auth=' + encodeURIComponent(auth),
        type:'POST',
        data: JSON.stringify(json),
        contentType:'application/json; charset=utf-8',
        success: function () {
            log('updated settings');
        }
    })
    .fail (function () {
        alert (i18n.t('Failed to update settings'))
    });
}

function rKeys (data) {
    var keys = data.keys;
    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var tr = $('<tr>');
        var td1 = $('<td>');
        var select = $('<input type="checkbox" class="keycheck" id="key' + i + '" value="' + i + '">');
        td1.append(select);
        var td2 = $('<td>');
        var ids = key.ids;
        for (var j = 0; j < ids.length; j++) {
            td2.append(ids[j].replace('<', '&lt').replace('>', '&gt') + '<br>');
        }
        var td3 = $('<td>');
        var fingerprints = key.fingerprints;
        for (var k = 0; k < fingerprints.length; k++) {
            td3.append(fingerprints[k] + '<br>');
        }
        var td4 = $('<td>');
        var pass = $('<input type="password" id="pass' + i + '">');
        td4.append(pass);
        tr.append(td1).append(td2).append(td3).append(td4);
        $('#keytable').append(tr);
    }
    view('listkeys');
}

function downloadKeys() {
    var keys = [];
    $('.keycheck').each(function (e,v) {
       if ($(v).is(':checked')) {
           var index = $(v).val();
           key = {
                   username : username,
                   index : index,
                   password : $('#pass' + index).val()
           }
           keys.push(key);
       };
    });
    if (keys.length === 0) {
        alert(i18n.t('No keys selected'));
        return;
    }
    $('#keys').html(i18n.t('Click to download') + '<br><br>');
    for (var i = 0; i < keys.length; i++) {
        $.ajax({
            url: root + '/oxguard/retrieve?action=getkeys&session=' + sessionID + '&auth=' + encodeURIComponent(auth),
            type:'POST',
            data: JSON.stringify(keys[i]),
            contentType:'application/json; charset=utf-8',
            success: function (data) {
                var filename = i18n.t('Key');
                if (data.keydata.ids.length > 0) {
                    filename = data.keydata.ids[0];
                }
                var a = $('<a href="data:application/pgp;charset=utf-8,' + data.data + '" download="' + filename + '.asc" class="downloadkey">' + filename.replace('<','&lt').replace('>','&gt') + '</a>');
                $('#keys').append(a).append('<br><br>');
                $('#keys').show();
            }
        })
        .fail (function (err) {
            if (err.responseText.trim() === 'bad password') {
                alert(i18n.t('Bad Password'));
                return;
            }
            if (err.responseText.trim() === 'lockout') {
                alert(i18n.t('Account locked out try later'));
                return;
            }
            alert(i18n.t('Fail'));
            console.log(err);
        });
    }


}

function logOut () {
    $.get(root + '/oxguard/login?action=logout&auth=' + encodeURIComponent(auth))
    .done(function () {
        view('logout');
    })
    .fail(function () {
        alert(i18n.t('Fail'));
    });

}

function log (where, data) {
    if (!debug) return;
    if (typeof console === "undefined" || typeof console.log === "undefined") return;// Close if IE dev tools not open
    console.log(where);
    console.log(data);
}

var debug = (getURLParameter("debug") === "1");



