/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.servlets.supportApi;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.exception.OXException;
import com.openexchange.guard.common.servlets.utils.ServletUtils;
import com.openexchange.guard.guestupgrade.GuestUpgradeService;
import com.openexchange.guard.inputvalidation.EmailValidator;
import com.openexchange.guard.osgi.Services;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.GuardUserSession;
import com.openexchange.guard.support.SupportService;
import com.openexchange.guard.support.SupportServiceImpl;


/**
 * {@link UpgradeGuestAction}
 * Upgrades Guest account to full OX account
 *
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 * @since v2.10.0
 */
public class UpgradeGuestAction extends GuardServletAction {

    private final GuestUpgradeService upgradeService;

    /**
     * Initializes a new {@link UpgradeGuestAction}.
     * @throws OXException
     */
    public UpgradeGuestAction() throws OXException{
        upgradeService = Objects.requireNonNull(Services.getService(GuestUpgradeService.class), "UpgradeService not available");
    }

    @Override
    protected void doActionInternal(HttpServletRequest request, HttpServletResponse response, GuardUserSession userSession) throws Exception {
        final String email = new EmailValidator().assertInput(ServletUtils.getStringParameter(request,"email", true /*mandatory*/), "email");
        final String userid = ServletUtils.getStringParameter(request, "user_id", true);
        final String cid = ServletUtils.getStringParameter(request, "cid", true);
        try {
            upgradeService.upgrade(email, userid, cid);
        } catch (OXException ex) {
            ServletUtils.sendError(response, ex);
            return;
        }
        ServletUtils.sendOK(response, "text/plain", "OK");
    }
}
