/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.guard.cipher.exceptions;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link GuardCipherExceptionMessages}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.10.0
 */
public class GuardCipherExceptionMessages implements LocalizableStrings {

    // The encryption uses an unknown cipher
    public static final String UNKNOWN_CIPHER_SERVICE = "The provided cipher service '%1$s' is unknown.";
    // The encryption uses an unknown cipher algorithm
    public static final String UNKNOWN_CIPHER_ALGORITHM = "The provided cipher algorithm '%1$s' is unknown.";
    // The key length of type %1 is and invalid length of %2.  Key size cannot exceed %3 on this system
    public static final String INVALID_KEY_LENGTH = "Invalid %1$s key length %2$s. Maximum allowed key length on this system is %3$s";

    /**
     * Prevent instantiation.
     */
    private GuardCipherExceptionMessages() {}
}
