/**
 * I work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. I work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under I license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2017 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Greg Hill <greg.hill@open-xchange.com>
 */

/// <reference path="../../steps.d.ts" />

Feature('Key Creation');

Before(async function (users) {
    await users.create();
    await users.create();  // Two users
});

After(async function (users) {
    await users.removeAll();
});

async function doSetup(I, userdata) {
    I.waitForVisible('.wizard-content');
    I.see('Welcome to Guard', '.wizard-content');
    I.click('Start Setup');

    I.waitForVisible('.password');
    I.waitForVisible('#newogpassword');
    I.insertCryptPassword('#newogpassword', userdata);
    I.wait(1);
    I.insertCryptPassword('#newogpassword2', userdata);
    I.click('Next');

    I.waitForVisible('.wizard-title');
    I.see('Guard set up completed', '.wizard-title');
    I.click('Close');
}

Scenario('Create keys from within compose', async function (I, users) {
    const o1 = {
        user: users[0]
    };

    const userdata = o1.user.userdata;

    I.login('app=io.ox/mail', o1);
    I.waitForVisible('.io-ox-mail-window .window-body .classic-toolbar');

    I.click('Compose');
    I.waitForVisible('.window-blocker.io-ox-busy');
    I.waitForInvisible('.window-blocker.io-ox-busy');
    I.waitForVisible('.io-ox-mail-compose textarea.plain-text,.io-ox-mail-compose .contenteditable-editor');

    I.click('.toggle-encryption');

    doSetup(I, userdata);
    I.auth(userdata);

    I.waitForVisible('.fa.fa-2x.encrypted');

});

Scenario('Create keys from within drive', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;
    const infostoreFolderID = await I.grabDefaultFolder('infostore');
    let fileId = await I.haveFile(infostoreFolderID, 'e2e/testFiles/simpleText.txt', o);
    let id = fileId.folder_id + '.' + fileId.id;

    I.login('app=io.ox/files', o);


    // Start to encrypt the file
    I.waitForVisible('.list-view li[data-cid="' + id + '"]');
    I.click('.list-view li[data-cid="' + id + '"]');
    I.wait(1);
    I.click('.dropdown-toggle[data-action="more"]');
    I.click('.dropdown-menu [data-action="oxguard/encrypt"]');

    doSetup(I, userdata);

    I.waitForVisible('.file-type-guard');
    I.see('simpleText.txt.pgp', '.list-view');
    I.logout();
});

Scenario('Key creation in setup', async function (I, users) {

    const o = {
        user: users[0]
    };
    const userdata = o.user.userdata;

    // Log in to settings
    I.login(['app=io.ox/settings', 'folder=virtual/settings/oxguard'], o);
    I.waitForElement('.io-ox-guard-settings');
    I.waitForElement('.guard-start-button');

    // Click the setup button and verify wizard;
    I.click('.guard-start-button');

    doSetup(I, userdata);

    // Verify settings now shown
    I.waitForVisible('.btn#changePassword');
});
